/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.io.Writer;
import org.neo4j.adversaries.Adversary;

public class AdversarialWriter
extends Writer {
    private final Writer writer;
    private final Adversary adversary;

    public AdversarialWriter(Writer writer, Adversary adversary) {
        this.writer = writer;
        this.adversary = adversary;
    }

    @Override
    public void write(int c) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.writer.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.adversary.injectFailure(StringIndexOutOfBoundsException.class, IOException.class, IndexOutOfBoundsException.class, ArrayStoreException.class, NullPointerException.class);
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.adversary.injectFailure(StringIndexOutOfBoundsException.class, IOException.class, IndexOutOfBoundsException.class, ArrayStoreException.class, NullPointerException.class);
        this.writer.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.adversary.injectFailure(StringIndexOutOfBoundsException.class, IOException.class, IndexOutOfBoundsException.class, ArrayStoreException.class, NullPointerException.class);
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.adversary.injectFailure(StringIndexOutOfBoundsException.class, IOException.class, IndexOutOfBoundsException.class, ArrayStoreException.class, NullPointerException.class);
        return this.writer.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.writer.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.writer.close();
    }
}

