/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.util.concurrent.BinaryLatch;

public class TinyLockManager {
    private final ConcurrentHashMap<Integer, BinaryLatch> map = new ConcurrentHashMap(64, 0.75f, 64);

    public void lock(int recordId) {
        BinaryLatch existingLatch;
        Integer record = recordId;
        BinaryLatch myLatch = new BinaryLatch();
        while ((existingLatch = this.map.putIfAbsent(record, myLatch)) != null) {
            existingLatch.await();
        }
    }

    public boolean tryLock(int recordId) {
        BinaryLatch myLatch;
        Integer record = recordId;
        BinaryLatch existingLatch = this.map.putIfAbsent(record, myLatch = new BinaryLatch());
        return existingLatch == null;
    }

    public void unlock(int recordId) {
        this.map.remove(recordId).release();
    }
}

