/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert;

import java.io.IOException;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.batchinsert.internal.FileSystemClosingBatchInserter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.service.Services;

public final class BatchInserters {
    public static BatchInserter inserter(DatabaseLayout databaseLayout) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter batchInserter = BatchInserters.inserter(databaseLayout, (FileSystemAbstraction)fileSystem, Config.defaults());
        return new FileSystemClosingBatchInserter(batchInserter, (FileSystemAbstraction)fileSystem);
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, FileSystemAbstraction fs) throws IOException {
        return BatchInserters.inserter(databaseLayout, fs, Config.defaults((Setting)GraphDatabaseSettings.preallocate_logical_logs, (Object)Boolean.FALSE), BatchInserters.loadExtension());
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, Config config) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserter inserter = BatchInserters.inserter(databaseLayout, (FileSystemAbstraction)fileSystem, config, BatchInserters.loadExtension());
        return new FileSystemClosingBatchInserter(inserter, (FileSystemAbstraction)fileSystem);
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, FileSystemAbstraction fs, Config config) throws IOException {
        return BatchInserters.inserter(databaseLayout, fs, config, BatchInserters.loadExtension());
    }

    public static BatchInserter inserter(DatabaseLayout databaseLayout, Config config, Iterable<ExtensionFactory<?>> extensions) throws IOException {
        DefaultFileSystemAbstraction fileSystem = BatchInserters.createFileSystem();
        BatchInserterImpl inserter = new BatchInserterImpl(databaseLayout, (FileSystemAbstraction)fileSystem, config, extensions, DatabaseTracers.EMPTY);
        return new FileSystemClosingBatchInserter(inserter, (FileSystemAbstraction)fileSystem);
    }

    public static BatchInserter inserter(DatabaseLayout layout, FileSystemAbstraction fileSystem, Config config, Iterable<ExtensionFactory<?>> extensions) throws IOException {
        return new BatchInserterImpl(layout, fileSystem, config, extensions, DatabaseTracers.EMPTY);
    }

    private static DefaultFileSystemAbstraction createFileSystem() {
        return new DefaultFileSystemAbstraction();
    }

    private static Iterable loadExtension() {
        return Services.loadAll(ExtensionFactory.class);
    }
}

