/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.neo4j.bolt.v1.packstream.PackInput;

public class PackedInputArray
implements PackInput {
    private final ByteArrayInputStream bytes;
    private final DataInputStream data;

    public PackedInputArray(byte[] bytes) {
        this.bytes = new ByteArrayInputStream(bytes);
        this.data = new DataInputStream(this.bytes);
    }

    @Override
    public byte readByte() throws IOException {
        return this.data.readByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.data.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.data.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.data.readLong();
    }

    @Override
    public double readDouble() throws IOException {
        return this.data.readDouble();
    }

    @Override
    public PackInput readBytes(byte[] into, int offset, int toRead) throws IOException {
        this.data.read(into, offset, toRead);
        return this;
    }

    @Override
    public byte peekByte() throws IOException {
        this.data.mark(1);
        byte value = this.data.readByte();
        this.data.reset();
        return value;
    }
}

