/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.request;

import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.messaging.RequestMessage;

public class InitMessage
implements RequestMessage {
    public static final byte SIGNATURE = 1;
    private final String userAgent;
    private final Map<String, Object> authToken;

    public InitMessage(String userAgent, Map<String, Object> authToken) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.authToken = Objects.requireNonNull(authToken);
    }

    public String userAgent() {
        return this.userAgent;
    }

    public Map<String, Object> authToken() {
        return this.authToken;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitMessage that = (InitMessage)o;
        return Objects.equals(this.userAgent, that.userAgent) && Objects.equals(this.authToken, that.authToken);
    }

    public int hashCode() {
        return Objects.hash(this.userAgent, this.authToken);
    }

    public String toString() {
        return "INIT " + this.userAgent + ' ' + this.authToken;
    }
}

