/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3;

import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.AbstractBoltProtocol;
import org.neo4j.bolt.v3.messaging.BoltRequestMessageReaderV3;
import org.neo4j.bolt.v3.messaging.BoltResponseMessageWriterV3;
import org.neo4j.logging.internal.LogService;

public class BoltProtocolV3
extends AbstractBoltProtocol {
    public static final long VERSION = 3L;

    public BoltProtocolV3(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logging) {
        super(channel, connectionFactory, stateMachineFactory, logging);
    }

    @Override
    protected Neo4jPack createPack() {
        return new Neo4jPackV2();
    }

    @Override
    public long version() {
        return 3L;
    }

    @Override
    protected BoltRequestMessageReader createMessageReader(BoltChannel channel, Neo4jPack neo4jPack, BoltConnection connection, BookmarksParser bookmarksParser, LogService logging) {
        BoltResponseMessageWriterV3 responseWriter = new BoltResponseMessageWriterV3(neo4jPack, connection.output(), logging);
        return new BoltRequestMessageReaderV3(connection, responseWriter, logging);
    }
}

