/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.io.IOException;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.v3.messaging.MessageProcessingHandler;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;

public class ResultHandler
extends MessageProcessingHandler {
    public ResultHandler(BoltResponseMessageWriter handler, BoltConnection connection, Log log) {
        super(handler, connection, log);
    }

    @Override
    public boolean onPullRecords(BoltResult result, long size) throws Throwable {
        return this.markHasMore(result.handleRecords(new RecordWritingBoltResultRecordConsumer(), size));
    }

    @Override
    public boolean onDiscardRecords(BoltResult result, long size) throws Throwable {
        return this.markHasMore(result.discardRecords(new RecordDiscardingBoltResultRecordConsumer(), size));
    }

    private boolean markHasMore(boolean hasMore) {
        if (hasMore) {
            this.onMetadata("has_more", (AnyValue)BooleanValue.TRUE);
        }
        return hasMore;
    }

    private class RecordDiscardingBoltResultRecordConsumer
    extends BoltResult.DiscardingRecordConsumer {
        private RecordDiscardingBoltResultRecordConsumer() {
        }

        @Override
        public void addMetadata(String key, AnyValue value) {
            ResultHandler.this.onMetadata(key, value);
        }
    }

    private class RecordWritingBoltResultRecordConsumer
    implements BoltResult.RecordConsumer {
        private RecordWritingBoltResultRecordConsumer() {
        }

        @Override
        public void addMetadata(String key, AnyValue value) {
            ResultHandler.this.onMetadata(key, value);
        }

        @Override
        public void beginRecord(int numberOfFields) throws IOException {
            ResultHandler.this.messageWriter.beginRecord(numberOfFields);
        }

        @Override
        public void consumeField(AnyValue value) throws IOException {
            ResultHandler.this.messageWriter.consumeField(value);
        }

        @Override
        public void endRecord() throws IOException {
            ResultHandler.this.messageWriter.endRecord();
        }

        @Override
        public void onError() {
            ResultHandler.this.messageWriter.onError();
        }
    }
}

