/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.Map;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.messaging.BoltAuthenticationHelper;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ConnectedState
implements BoltStateMachineState {
    private static final String CONNECTION_ID_KEY = "connection_id";
    private BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof HelloMessage) {
            Map<String, Object> authToken;
            HelloMessage helloMessage = (HelloMessage)message;
            String userAgent = helloMessage.userAgent();
            if (BoltAuthenticationHelper.processAuthentication(userAgent, authToken = helloMessage.authToken(), context)) {
                context.connectionState().onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.stringValue((String)context.connectionId()));
                return this.readyState;
            }
            return null;
        }
        return null;
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
    }
}

