/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.util.Preconditions;

public abstract class FailSafeBoltStateMachineState
implements BoltStateMachineState {
    private BoltStateMachineState failedState;
    private BoltStateMachineState interruptedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        try {
            return this.processUnsafe(message, context);
        }
        catch (AuthorizationExpiredException e) {
            context.handleFailure(e, true);
            return this.failedState;
        }
        catch (Throwable t) {
            context.handleFailure(t, false);
            return this.failedState;
        }
    }

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    protected void assertInitialized() {
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
    }

    protected abstract BoltStateMachineState processUnsafe(RequestMessage var1, StateMachineContext var2) throws Throwable;
}

