/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.MutableConnectionState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineContextImpl;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.v3.messaging.request.InterruptSignal;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public abstract class AbstractBoltStateMachine
implements BoltStateMachine {
    private final String id;
    private final BoltChannel boltChannel;
    private final BoltStateMachineSPI spi;
    protected final MutableConnectionState connectionState;
    private final StateMachineContext context;
    private BoltStateMachineState state;
    private final BoltStateMachineState failedState;

    public AbstractBoltStateMachine(BoltStateMachineSPI spi, BoltChannel boltChannel, Clock clock) {
        this.id = boltChannel.id();
        this.boltChannel = boltChannel;
        this.spi = spi;
        this.connectionState = new MutableConnectionState();
        this.context = new BoltStateMachineContextImpl(this, boltChannel, spi, this.connectionState, clock);
        States states = this.buildStates();
        this.state = states.initial;
        this.failedState = states.failed;
    }

    @Override
    public void process(RequestMessage message, BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (message.safeToProcessInAnyState() || this.connectionState.canProcessMessage()) {
                this.nextState(message, this.context);
            }
        }
        finally {
            this.after();
        }
    }

    private void before(BoltResponseHandler handler) throws BoltConnectionFatality {
        if (this.connectionState.isTerminated()) {
            this.close();
        } else if (this.connectionState.isInterrupted()) {
            this.nextState(InterruptSignal.INSTANCE, this.context);
        }
        this.connectionState.setResponseHandler(handler);
    }

    protected void after() {
        if (this.connectionState.getResponseHandler() != null) {
            try {
                Neo4jError pendingError = this.connectionState.getPendingError();
                if (pendingError != null) {
                    this.connectionState.markFailed(pendingError);
                }
                if (this.connectionState.hasPendingIgnore()) {
                    this.connectionState.markIgnored();
                }
                this.connectionState.resetPendingFailedAndIgnored();
                this.connectionState.getResponseHandler().onFinish();
            }
            finally {
                this.connectionState.setResponseHandler(null);
            }
        }
    }

    private void nextState(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        BoltStateMachineState preState = this.state;
        this.state = this.state.process(message, context);
        if (this.state == null) {
            String msg = "Message '" + message + "' cannot be handled by a session in the " + preState.name() + " state.";
            this.fail(Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }
    }

    @Override
    public void markFailed(Neo4jError error) {
        this.fail(error);
        this.state = this.failedState;
    }

    @Override
    public void interrupt() {
        this.connectionState.incrementInterruptCounter();
        this.statementProcessor().markCurrentTransactionForTermination();
    }

    @Override
    public void validateTransaction() throws KernelException {
        Status status = this.statementProcessor().validateTransaction();
        if (status != null) {
            this.connectionState().setPendingTerminationNotice(status);
        }
    }

    @Override
    public void handleExternalFailure(Neo4jError error, BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.connectionState.canProcessMessage()) {
                this.fail(error);
                this.state = this.failedState;
            }
        }
        finally {
            this.after();
        }
    }

    @Override
    public boolean isClosed() {
        return this.connectionState.isClosed();
    }

    @Override
    public void close() {
        try {
            this.boltChannel.close();
        }
        finally {
            this.connectionState.markClosed();
            this.resetStatementProcessor();
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void markForTermination() {
        this.connectionState.markTerminated();
        this.statementProcessor().markCurrentTransactionForTermination();
    }

    @Override
    public boolean shouldStickOnThread() {
        return this.statementProcessor().hasTransaction() || this.statementProcessor().hasOpenStatement();
    }

    @Override
    public boolean hasOpenStatement() {
        return this.statementProcessor().hasOpenStatement();
    }

    @Override
    public boolean reset() throws BoltConnectionFatality {
        try {
            this.resetStatementProcessor();
            return true;
        }
        catch (Throwable t) {
            this.handleFailure(t, true);
            return false;
        }
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        if (ExceptionUtils.indexOfType((Throwable)cause, BoltConnectionFatality.class) != -1) {
            fatal = true;
        }
        Neo4jError error = fatal ? Neo4jError.fatalFrom(cause) : Neo4jError.from(cause);
        this.fail(error);
        if (error.isFatal()) {
            if (ExceptionUtils.indexOfType((Throwable)cause, AuthorizationExpiredException.class) != -1) {
                throw new BoltConnectionAuthFatality("Failed to process a bolt message", cause);
            }
            if (cause instanceof AuthenticationException) {
                throw new BoltConnectionAuthFatality((AuthenticationException)cause);
            }
            throw new BoltConnectionFatality("Failed to process a bolt message", cause);
        }
    }

    public BoltStateMachineState state() {
        return this.state;
    }

    public StatementProcessor statementProcessor() {
        return this.connectionState.getStatementProcessor();
    }

    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    private void fail(Neo4jError neo4jError) {
        this.spi.reportError(neo4jError);
        if (this.state == this.failedState) {
            this.connectionState.markIgnored();
        } else {
            this.connectionState.markFailed(neo4jError);
        }
    }

    private void resetStatementProcessor() {
        try {
            this.statementProcessor().reset();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract States buildStates();

    public static class States {
        final BoltStateMachineState initial;
        final BoltStateMachineState failed;

        public States(BoltStateMachineState initial, BoltStateMachineState failed) {
            this.initial = initial;
            this.failed = failed;
        }
    }
}

