/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.accounting.error;

import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public final class NoopErrorAccountant
implements ErrorAccountant {
    private final Log userLog;

    public NoopErrorAccountant(LogService logging) {
        this.userLog = logging.getUserLog(NoopErrorAccountant.class);
    }

    @Override
    public void notifyNetworkAbort(Connection connection, Throwable cause) {
        this.userLog.warn("[" + connection.id() + "] Terminating connection due to network error", cause);
    }

    @Override
    public void notifyThreadStarvation(Connection connection, Throwable cause) {
        this.userLog.error("[%s] Unable to schedule for execution since there are no available threads to serve it at the moment.", new Object[]{connection.id()});
    }
}

