/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.memory.HeapEstimator;

public class TrafficAccountantHandler
extends ChannelDuplexHandler {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOf(TrafficAccountantHandler.class);
    public static final String NAME = "trafficAccountantHandler";
    private final TrafficAccountant accountant;
    private Connection connection;

    public TrafficAccountantHandler(TrafficAccountant accountant) {
        this.accountant = accountant;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.connection = Connection.getConnection(ctx.channel());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.accountant.notifyRead(buf.readableBytes());
        }
        super.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        this.accountant.tryCheck();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.accountant.notifyWrite(buf.readableBytes());
        }
        super.write(ctx, msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        super.flush(ctx);
        this.accountant.tryCheck();
    }
}

