/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.streaming;

import java.util.OptionalLong;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.request.streaming.AbstractStreamingMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.packstream.util.PackstreamConversions;
import org.neo4j.values.virtual.MapValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractStreamingMessageDecoder<M extends AbstractStreamingMessage>
implements MessageDecoder<M> {
    private static final String FIELD_STREAM_LIMIT = "n";
    private static final String FIELD_QUERY_ID = "qid";
    private static final long STREAM_LIMIT_MINIMAL = 1L;
    public static final long STREAM_LIMIT_UNLIMITED = -1L;

    @Override
    public M read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue meta;
        PackstreamConditions.requireLength(header, 1);
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            meta = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("meta", ex);
        }
        try {
            long n = this.readStreamLimit(meta);
            long statementId = this.readStatementId(meta);
            return this.createMessageInstance(n, statementId);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("meta", ex);
        }
    }

    protected abstract M createMessageInstance(long var1, long var3);

    protected long readStreamLimit(MapValue meta) throws PackstreamReaderException {
        long size = PackstreamConversions.asLongValue(FIELD_STREAM_LIMIT, meta.get(FIELD_STREAM_LIMIT));
        if (size != -1L && size < 1L) {
            throw new IllegalStructArgumentException(FIELD_STREAM_LIMIT, String.format("Expecting size to be at least %s, but got: %s", 1L, size));
        }
        return size;
    }

    protected long readStatementId(MapValue meta) throws PackstreamReaderException {
        OptionalLong statementId = PackstreamConversions.asNullableLongValue(FIELD_QUERY_ID, meta.get(FIELD_QUERY_ID));
        if (!statementId.isPresent()) {
            return -1L;
        }
        return statementId.getAsLong();
    }
}

