/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx.error;

import org.neo4j.bolt.tx.error.TransactionCreationException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.kernel.api.exceptions.Status;

public class DatabaseUnavailableTransactionCreationException
extends TransactionCreationException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public DatabaseUnavailableTransactionCreationException(String databaseName, Throwable cause) {
        super(String.format("Database '%s' is unavailable.", databaseName), cause);
        this.gqlStatusObject = null;
        this.oldMessage = String.format("Database '%s' is unavailable.", databaseName);
    }

    public DatabaseUnavailableTransactionCreationException(ErrorGqlStatusObject gqlStatusObject, String databaseName, Throwable cause) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)String.format("Database '%s' is unavailable.", databaseName)), cause);
        this.gqlStatusObject = gqlStatusObject;
        this.oldMessage = String.format("Database '%s' is unavailable.", databaseName);
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return Status.General.DatabaseUnavailable;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

