/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;

public class LimitExceededException
extends PackstreamReaderException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final long limit;
    private final long actual;
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public LimitExceededException(long limit, long actual) {
        super("Value of size " + actual + " exceeded limit of " + limit);
        this.limit = limit;
        this.actual = actual;
        this.gqlStatusObject = null;
        this.oldMessage = "Value of size " + actual + " exceeded limit of " + limit;
    }

    public LimitExceededException(ErrorGqlStatusObject gqlStatusObject, long limit, long actual) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Value of size " + actual + " exceeded limit of " + limit)));
        this.gqlStatusObject = gqlStatusObject;
        this.limit = limit;
        this.actual = actual;
        this.oldMessage = "Value of size " + actual + " exceeded limit of " + limit;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getActual() {
        return this.actual;
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return Status.Request.Invalid;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

