/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.logging;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.concurrent.AsyncEvents;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.async.AsyncLogEvent;
import org.neo4j.logging.async.AsyncLogProvider;
import org.neo4j.util.FeatureToggles;

public class AsyncLogging
extends LifecycleAdapter
implements Consumer<AsyncLogEvent>,
AsyncEvents.Monitor {
    private static final boolean ENABLED = FeatureToggles.flag(AsyncLogging.class, (String)"ENABLED", (boolean)true);
    private final Log metaLog;
    private final AsyncEvents<AsyncLogEvent> events;
    private long highCount;
    private ExecutorService executor;

    public static LogProvider provider(LifeSupport life, LogProvider provider) {
        if (ENABLED) {
            if (provider instanceof NullLogProvider) {
                return provider;
            }
            return new AsyncLogProvider(((AsyncLogging)life.add((Lifecycle)new AsyncLogging(provider.getLog(AsyncLogging.class)))).eventSender(), provider);
        }
        return provider;
    }

    AsyncLogging(Log metaLog) {
        this.metaLog = metaLog;
        this.events = new AsyncEvents((Consumer)this, (AsyncEvents.Monitor)this);
    }

    @Override
    public void accept(AsyncLogEvent event) {
        event.process();
    }

    public void start() {
        this.highCount = 0L;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.getClass().getSimpleName()));
        this.executor.submit((Runnable)this.events);
        this.events.awaitStartup();
    }

    public void stop() {
        this.events.shutdown();
        this.executor.shutdown();
        this.events.awaitTermination();
    }

    public void eventCount(long count) {
        if (this.metaLog.isDebugEnabled() && count > this.highCount) {
            this.metaLog.debug("High mark increasing from %d to %d events", new Object[]{this.highCount, count});
            this.highCount = count;
        }
    }

    AsyncEventSender<AsyncLogEvent> eventSender() {
        return this.events;
    }
}

