/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstance;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;

public class InMemoryAcceptorInstanceStore
implements AcceptorInstanceStore {
    private final Map<InstanceId, AcceptorInstance> instances;
    private final BlockingQueue<InstanceId> currentInstances;
    private long lastDeliveredInstanceId;

    public InMemoryAcceptorInstanceStore() {
        this(new HashMap<InstanceId, AcceptorInstance>(), new ArrayBlockingQueue<InstanceId>(1000), -1L);
    }

    private InMemoryAcceptorInstanceStore(Map<InstanceId, AcceptorInstance> instances, BlockingQueue<InstanceId> currentInstances, long lastDeliveredInstanceId) {
        this.instances = instances;
        this.lastDeliveredInstanceId = lastDeliveredInstanceId;
        this.currentInstances = currentInstances;
    }

    @Override
    public AcceptorInstance getAcceptorInstance(InstanceId instanceId) {
        AcceptorInstance instance = this.instances.get(instanceId);
        if (instance == null) {
            instance = new AcceptorInstance();
            this.instances.put(instanceId, instance);
            if (!this.currentInstances.offer(instanceId)) {
                this.instances.remove(this.currentInstances.poll());
                this.currentInstances.offer(instanceId);
            }
        }
        return instance;
    }

    @Override
    public void promise(AcceptorInstance instance, long ballot) {
        instance.promise(ballot);
    }

    @Override
    public void accept(AcceptorInstance instance, Object value) {
        instance.accept(value);
    }

    @Override
    public void lastDelivered(InstanceId instanceId) {
        this.lastDeliveredInstanceId = instanceId.getId();
    }

    @Override
    public void clear() {
        this.instances.clear();
    }

    public InMemoryAcceptorInstanceStore snapshot() {
        return new InMemoryAcceptorInstanceStore(new HashMap<InstanceId, AcceptorInstance>(this.instances), new ArrayBlockingQueue<InstanceId>(this.currentInstances.size() + this.currentInstances.remainingCapacity(), false, this.currentInstances), this.lastDeliveredInstanceId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryAcceptorInstanceStore that = (InMemoryAcceptorInstanceStore)o;
        if (this.lastDeliveredInstanceId != that.lastDeliveredInstanceId) {
            return false;
        }
        return this.instances.equals(that.instances);
    }

    public int hashCode() {
        int result = this.instances.hashCode();
        result = 31 * result + (int)(this.lastDeliveredInstanceId ^ this.lastDeliveredInstanceId >>> 32);
        return result;
    }
}

