/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.util.concurrent.Executor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.cluster.util.Quorums;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;

class AtomicBroadcastContextImpl
extends AbstractContextImpl
implements AtomicBroadcastContext {
    private final Listeners<AtomicBroadcastListener> listeners = new Listeners();
    private final Executor executor;
    private final HeartbeatContext heartbeatContext;

    AtomicBroadcastContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Executor executor, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.executor = executor;
        this.heartbeatContext = heartbeatContext;
    }

    @Override
    public void addAtomicBroadcastListener(AtomicBroadcastListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeAtomicBroadcastListener(AtomicBroadcastListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void receive(Payload value) {
        this.listeners.notify(this.executor, listener -> listener.receive(value));
    }

    public AtomicBroadcastContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, Executor executor, HeartbeatContext heartbeatContext) {
        return new AtomicBroadcastContextImpl(this.me, commonStateSnapshot, logging, timeouts, executor, heartbeatContext);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean hasQuorum() {
        int availableMembers = (int)Iterables.count(this.heartbeatContext.getAlive());
        int totalMembers = this.commonState.configuration().getMembers().size();
        return Quorums.isQuorum(availableMembers, totalMembers);
    }
}

