/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.statemachine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.StateMachines;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.statemachine.StateMachineConversations;
import org.neo4j.cluster.statemachine.StateMachineProxyHandler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StateMachineProxyFactory
implements MessageProcessor {
    private final StateMachines stateMachines;
    private final StateMachineConversations conversations;
    private final Log log;
    private volatile InstanceId me;
    private final Map<String, ResponseFuture> responseFutureMap = new ConcurrentHashMap<String, ResponseFuture>();

    public StateMachineProxyFactory(StateMachines stateMachines, StateMachineConversations conversations, InstanceId me, LogProvider logProvider) {
        this.stateMachines = stateMachines;
        this.conversations = conversations;
        this.me = me;
        this.log = logProvider.getLog(this.getClass());
    }

    public <CLIENT> CLIENT newProxy(Class<CLIENT> proxyInterface) throws IllegalArgumentException {
        StateMachine stateMachine = this.getStateMachine(proxyInterface);
        return proxyInterface.cast(Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new StateMachineProxyHandler(this, stateMachine)));
    }

    Object invoke(StateMachine stateMachine, Method method, Object arg) {
        if (method.getName().equals("toString")) {
            return this.me.toString();
        }
        if (method.getName().equals("equals")) {
            return ((StateMachineProxyHandler)Proxy.getInvocationHandler((Object)arg)).getStateMachineProxyFactory().me.equals(this.me);
        }
        String conversationId = this.conversations.getNextConversationId();
        try {
            MessageType typeAsEnum = (MessageType)Enum.valueOf(stateMachine.getMessageType(), method.getName());
            Message<MessageType> message = Message.internal(typeAsEnum, arg);
            if (this.me != null) {
                message.setHeader("conversation-id", conversationId).setHeader("created-by", this.me.toString());
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                this.stateMachines.process(message);
                return null;
            }
            ResponseFuture future = new ResponseFuture(conversationId, typeAsEnum, this.responseFutureMap);
            this.responseFutureMap.put(conversationId, future);
            this.log.debug("Added response future for conversation id %s", new Object[]{conversationId});
            this.stateMachines.process(message);
            return future;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("No state machine can handle the method " + method.getName());
        }
    }

    public boolean process(Message<?> message) {
        if (!this.responseFutureMap.isEmpty() && !message.hasHeader("to")) {
            String conversationId = message.getHeader("conversation-id");
            ResponseFuture future = this.responseFutureMap.get(conversationId);
            if (future != null) {
                if (future.setPotentialResponse(message)) {
                    this.responseFutureMap.remove(conversationId);
                }
            } else {
                this.log.warn("Unable to find the client (with the conversation id %s) waiting for the response %s.", new Object[]{conversationId, message});
            }
        }
        return true;
    }

    private StateMachine getStateMachine(Class<?> proxyInterface) throws IllegalArgumentException {
        IllegalArgumentException exception = new IllegalArgumentException("No state machine can handle the interface:" + proxyInterface.getName());
        block2: for (StateMachine stateMachine : this.stateMachines.getStateMachines()) {
            boolean foundMatch = false;
            for (Method method : proxyInterface.getMethods()) {
                if (!method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(Future.class)) {
                    throw new IllegalArgumentException("Methods must return either void or Future");
                }
                try {
                    Enum.valueOf(stateMachine.getMessageType(), method.getName());
                    foundMatch = true;
                }
                catch (Exception e) {
                    if (!foundMatch) continue block2;
                    exception = new IllegalArgumentException("State machine for " + stateMachine.getMessageType().getName() + " cannot handle method:" + method.getName());
                    continue block2;
                }
            }
            return stateMachine;
        }
        throw exception;
    }

    private static class ResponseFuture
    implements Future<Object> {
        private final String conversationId;
        private final MessageType initiatedByMessageType;
        private final Map<String, ResponseFuture> responseFutureMap;
        private Message response;

        ResponseFuture(String conversationId, MessageType initiatedByMessageType, Map<String, ResponseFuture> responseFutureMap) {
            this.conversationId = conversationId;
            this.initiatedByMessageType = initiatedByMessageType;
            this.responseFutureMap = responseFutureMap;
        }

        synchronized boolean setPotentialResponse(Message response) {
            if (this.isResponse(response)) {
                this.response = response;
                this.notifyAll();
                return true;
            }
            return false;
        }

        private boolean isResponse(Message response) {
            return response.getMessageType().name().equals(this.initiatedByMessageType.name() + "Response") || response.getMessageType().name().equals(this.initiatedByMessageType.name() + "Failure");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.response != null;
        }

        @Override
        public synchronized Object get() throws InterruptedException, ExecutionException {
            if (this.response != null) {
                return this.getResult();
            }
            while (this.response == null) {
                this.wait(50L);
            }
            return this.getResult();
        }

        private synchronized Object getResult() throws InterruptedException, ExecutionException {
            if (this.response.getMessageType().name().equals(this.initiatedByMessageType.name() + "Failure")) {
                if (this.response.getPayload() != null) {
                    if (this.response.getPayload() instanceof Throwable) {
                        throw new ExecutionException((Throwable)this.response.getPayload());
                    }
                    throw new InterruptedException(this.response.getPayload().toString());
                }
                throw new InterruptedException();
            }
            return this.response.getPayload();
        }

        @Override
        public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.response != null) {
                this.getResult();
            }
            this.wait(unit.toMillis(timeout));
            if (this.response == null) {
                throw new TimeoutException(String.format("Conversation-response mapping:%n" + this.responseFutureMap, new Object[0]));
            }
            return this.getResult();
        }

        public String toString() {
            return "ResponseFuture{conversationId='" + this.conversationId + '\'' + ", initiatedByMessageType=" + this.initiatedByMessageType + ", response=" + this.response + '}';
        }
    }
}

