/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.timeout;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.timeout.TimeoutStrategy;

public class MessageTimeoutStrategy
implements TimeoutStrategy {
    private Map<MessageType, Long> timeouts = new HashMap<MessageType, Long>();
    private TimeoutStrategy delegate;

    public MessageTimeoutStrategy(TimeoutStrategy delegate) {
        this.delegate = delegate;
    }

    public MessageTimeoutStrategy timeout(MessageType messageType, long timeout) {
        this.timeouts.put(messageType, timeout);
        return this;
    }

    public MessageTimeoutStrategy relativeTimeout(MessageType messageType, MessageType relativeTo, long timeout) {
        this.timeouts.put(messageType, this.timeouts.get(relativeTo) + timeout);
        return this;
    }

    @Override
    public long timeoutFor(Message message) {
        Long timeout = this.timeouts.get(message.getMessageType());
        if (timeout == null) {
            return this.delegate.timeoutFor(message);
        }
        return timeout;
    }

    @Override
    public void timeoutTriggered(Message timeoutMessage) {
        this.delegate.timeoutTriggered(timeoutMessage);
    }

    @Override
    public void timeoutCancelled(Message timeoutMessage) {
        this.delegate.timeoutCancelled(timeoutMessage);
    }

    @Override
    public void tick(long now) {
        this.delegate.tick(now);
    }
}

