/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.Lookup;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;

public abstract class ExpressionTemplate {
    protected final TypeReference type;

    protected ExpressionTemplate(TypeReference type) {
        this.type = type;
    }

    public static ExpressionTemplate self(TypeReference type) {
        return new ExpressionTemplate(type){

            @Override
            void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.load(new LocalVariable(method.clazz.handle(), "this", 0));
            }
        };
    }

    public static ExpressionTemplate invoke(final MethodReference method, final ExpressionTemplate ... arguments) {
        Expression[] materialized = ExpressionTemplate.tryMaterialize(arguments);
        if (materialized != null) {
            return Expression.invoke(method, materialized);
        }
        return new ExpressionTemplate(method.returns()){

            @Override
            protected void templateAccept(CodeBlock generator, ExpressionVisitor visitor) {
                visitor.invoke(method, 2.materialize(generator, arguments));
            }
        };
    }

    public static ExpressionTemplate invoke(final ExpressionTemplate target, final MethodReference method, final ExpressionTemplate ... arguments) {
        Expression[] materialized;
        if (target instanceof Expression && (materialized = ExpressionTemplate.tryMaterialize(arguments)) != null) {
            return Expression.invoke((Expression)target, method, materialized);
        }
        return new ExpressionTemplate(method.returns()){

            @Override
            protected void templateAccept(CodeBlock generator, ExpressionVisitor visitor) {
                visitor.invoke(target.materialize(generator), method, 3.materialize(generator, arguments));
            }
        };
    }

    public static ExpressionTemplate load(final String name, TypeReference type) {
        return new ExpressionTemplate(type){

            @Override
            protected void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.load(method.local(name));
            }
        };
    }

    public static ExpressionTemplate get(ExpressionTemplate target, Class<?> fieldType, String fieldName) {
        return ExpressionTemplate.get(target, TypeReference.typeReference(fieldType), fieldName);
    }

    public static ExpressionTemplate get(ExpressionTemplate target, TypeReference fieldType, String fieldName) {
        return ExpressionTemplate.get(target, Lookup.field(fieldType, fieldName), fieldType);
    }

    public static ExpressionTemplate get(final ExpressionTemplate target, final FieldReference field) {
        if (target instanceof Expression) {
            return Expression.get((Expression)target, field);
        }
        return new ExpressionTemplate(field.type()){

            @Override
            void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.getField(target.materialize(method), field);
            }
        };
    }

    public static ExpressionTemplate get(TypeReference fieldType, String fieldName) {
        return ExpressionTemplate.get(Lookup.field(fieldType, fieldName), fieldType);
    }

    public static ExpressionTemplate get(final ExpressionTemplate target, final Lookup<FieldReference> field, TypeReference type) {
        return new ExpressionTemplate(type){

            @Override
            void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.getField(target.materialize(method), (FieldReference)field.lookup(method));
            }
        };
    }

    public static ExpressionTemplate get(final Lookup<FieldReference> field, TypeReference type) {
        return new ExpressionTemplate(type){

            @Override
            void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.getStatic((FieldReference)field.lookup(method));
            }
        };
    }

    Expression materialize(final CodeBlock method) {
        return new Expression(this.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                ExpressionTemplate.this.templateAccept(method, visitor);
            }
        };
    }

    public static ExpressionTemplate cast(Class<?> clazz, ExpressionTemplate expression) {
        return ExpressionTemplate.cast(TypeReference.typeReference(clazz), expression);
    }

    public static ExpressionTemplate cast(TypeReference type, final ExpressionTemplate expression) {
        return new ExpressionTemplate(type){

            @Override
            protected void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.cast(this.type, expression.materialize(method));
            }
        };
    }

    abstract void templateAccept(CodeBlock var1, ExpressionVisitor var2);

    private static Expression[] tryMaterialize(ExpressionTemplate[] templates) {
        if (templates instanceof Expression[]) {
            return (Expression[])templates;
        }
        Expression[] materialized = new Expression[templates.length];
        for (int i = 0; i < materialized.length; ++i) {
            if (!(templates[i] instanceof Expression)) {
                return null;
            }
            materialized[i] = (Expression)templates[i];
        }
        return materialized;
    }

    static Expression[] materialize(CodeBlock method, ExpressionTemplate[] templates) {
        Expression[] expressions = new Expression[templates.length];
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i] = templates[i].materialize(method);
        }
        return expressions;
    }

    public static ExpressionTemplate invokeSuperConstructor(final ExpressionTemplate[] parameters, final TypeReference[] parameterTypes) {
        assert (parameters.length == parameterTypes.length);
        return new ExpressionTemplate(TypeReference.OBJECT){

            @Override
            void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
                visitor.invoke(Expression.SUPER, new MethodReference(method.clazz.handle().parent(), "<init>", TypeReference.VOID, 1, parameterTypes), 10.materialize(method, parameters));
            }
        };
    }

    public TypeReference type() {
        return this.type;
    }
}

