/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingLongIntHashMap
extends LongIntHashMap
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongIntHashMap.class);
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static HeapTrackingLongIntHashMap createLongIntHashMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongIntHashMap.arraysHeapSize(16));
        return new HeapTrackingLongIntHashMap(memoryTracker, 16);
    }

    private HeapTrackingLongIntHashMap(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongIntHashMap.arraysHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongIntHashMap.arraysHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongIntHashMap.arraysHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    private static long arraysHeapSize(int arrayLength) {
        long keyArray = HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + arrayLength * 8));
        long valueArray = HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + arrayLength * 4));
        return keyArray + valueArray;
    }
}

