/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class UTF8 {
    public static final int MINIMUM_SERIALISED_LENGTH_BYTES = 4;

    public static byte[] encode(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String getDecodedStringFrom(ByteBuffer source) {
        int remaining;
        int count = source.getInt();
        if (count > (remaining = source.remaining())) {
            throw UTF8.badStringFormatException(count, remaining);
        }
        byte[] data = new byte[count];
        source.get(data);
        return UTF8.decode(data);
    }

    private static IllegalArgumentException badStringFormatException(int count, int remaining) {
        return new IllegalArgumentException("Bad string format; claims string is " + count + " bytes long, but only " + remaining + " bytes remain in buffer");
    }

    public static void putEncodedStringInto(String text, ByteBuffer target) {
        byte[] data = UTF8.encode(text);
        target.putInt(data.length);
        target.put(data);
    }

    public static int computeRequiredByteBufferSize(String text) {
        return UTF8.encode(text).length + 4;
    }

    private UTF8() {
        throw new AssertionError((Object)"no instance");
    }
}

