/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.DelegatingMemoryPool;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPoolImpl;
import org.neo4j.memory.MemoryPoolTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

public class DatabaseMemoryGroupTracker
extends DelegatingMemoryPool
implements ScopedMemoryPool {
    private final GlobalMemoryGroupTracker parent;
    private final String name;
    private final MemoryTracker memoryTracker;

    DatabaseMemoryGroupTracker(GlobalMemoryGroupTracker parent, String name, long limit, boolean strict, boolean trackingEnabled, String limitSettingName) {
        super(new MemoryPoolImpl(limit, strict, limitSettingName));
        this.parent = parent;
        this.name = name;
        this.memoryTracker = trackingEnabled ? new MemoryPoolTracker(this) : EmptyMemoryTracker.INSTANCE;
    }

    @Override
    public MemoryGroup group() {
        return this.parent.group();
    }

    @Override
    public String databaseName() {
        return this.name;
    }

    @Override
    public void close() {
        this.parent.releasePool(this);
        this.parent.releaseNative(this.usedNative());
        this.parent.releaseHeap(this.usedHeap());
        this.memoryTracker.close();
    }

    @Override
    public MemoryTracker getPoolMemoryTracker() {
        return this.memoryTracker;
    }

    @Override
    public void reserveHeap(long bytes) {
        this.parent.reserveHeap(bytes);
        try {
            super.reserveHeap(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.parent.releaseHeap(bytes);
            throw e;
        }
    }

    @Override
    public void releaseHeap(long bytes) {
        super.releaseHeap(bytes);
        this.parent.releaseHeap(bytes);
    }

    @Override
    public void reserveNative(long bytes) {
        this.parent.reserveNative(bytes);
        try {
            super.reserveNative(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.parent.releaseNative(bytes);
            throw e;
        }
    }

    @Override
    public void releaseNative(long bytes) {
        super.releaseNative(bytes);
        this.parent.releaseNative(bytes);
    }
}

