/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.procedure.AppendStringProcedure;

public interface Mask {
    public static final Mask NO = new Mask(){

        @Override
        public String lazyFilter(Supplier<String> supplier) {
            return supplier.get();
        }

        @Override
        public void build(StringBuilder builder, Consumer<StringBuilder> build) {
            build.accept(builder);
        }
    };
    public static final Mask YES = new Mask(){
        private static final String PLACEHOLDER = "<MASKED>";

        @Override
        public String lazyFilter(Supplier<String> supplier) {
            return PLACEHOLDER;
        }

        @Override
        public void build(StringBuilder builder, Consumer<StringBuilder> build) {
            builder.append(PLACEHOLDER);
        }
    };

    default public String filter(Object value) {
        return this.lazyFilter(value::toString);
    }

    default public String filter(Iterable<? extends Maskable> iterable) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, iterable);
        return sb.toString();
    }

    public String lazyFilter(Supplier<String> var1);

    public void build(StringBuilder var1, Consumer<StringBuilder> var2);

    default public void append(StringBuilder builder, Iterable<? extends Maskable> iterable) {
        final AppendStringProcedure appendStringProcedure = new AppendStringProcedure((Appendable)builder, ", ");
        final Mask mask = this;
        Procedure<Maskable> appendMaskedStringProcedure = new Procedure<Maskable>(){

            public void value(Maskable each) {
                appendStringProcedure.value((Object)each.toString(mask));
            }
        };
        builder.append("[");
        iterable.forEach((Consumer<? extends Maskable>)appendMaskedStringProcedure);
        builder.append("]");
    }

    public static interface Maskable {
        public String toString(Mask var1);
    }
}

