/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.PrintWriter;
import org.neo4j.internal.helpers.progress.Indicator;

class BasicTextualIndicator
extends Indicator {
    static final int DEFAULT_RESOLUTION = 100;
    static final int DEFAULT_DISPLAY_STEP = 10;
    static final String DEFAULT_DISPLAY_TEXT = " %3d%% completed";
    private final String process;
    private final PrintWriter out;
    private final int step;
    private final String displayText;

    BasicTextualIndicator(String process, PrintWriter out, int resolution, int step, String displayText) {
        super(resolution);
        this.process = process;
        this.out = out;
        this.step = step;
        this.displayText = displayText;
    }

    @Override
    public void startProcess(long totalCount) {
        this.out.println(this.process);
        this.out.flush();
    }

    @Override
    protected void progress(int from, int to) {
        int i = from;
        while (i < to) {
            this.printProgress(++i);
        }
        this.out.flush();
    }

    @Override
    public void failure(Throwable cause) {
        cause.printStackTrace(this.out);
    }

    private void printProgress(int progress) {
        if (progress % this.step == 0) {
            this.out.printf(this.displayText, progress * 100 / this.reportResolution());
        }
    }
}

