/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Consumer;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;

public class BufferingLog
extends AbstractLog {
    private final Queue<LogMessage> buffer = new ArrayDeque<LogMessage>();

    public boolean isDebugEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.debug(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message, Throwable throwable) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.debug(message, throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String format, Object ... arguments) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.debug(format, arguments));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String message) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.info(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String message, Throwable throwable) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.info(message, throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String format, Object ... arguments) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.info(format, arguments));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String message) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.warn(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String message, Throwable throwable) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.warn(message, throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String format, Object ... arguments) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.warn(format, arguments));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.error(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message, Throwable throwable) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.error(message, throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String format, Object ... arguments) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            this.buffer.add(other -> other.error(format, arguments));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulk(Consumer<Log> consumer) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            consumer.accept((Log)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayInto(Log other) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            LogMessage message = this.buffer.poll();
            while (message != null) {
                message.replayInto(other);
                message = this.buffer.poll();
            }
        }
    }

    @FunctionalInterface
    private static interface LogMessage {
        public void replayInto(Log var1);
    }
}

