/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public class SocketAddress {
    private static final Set<String> WILDCARDS = new HashSet<String>(Arrays.asList("0.0.0.0", "::"));
    private final String hostname;
    private final int port;

    public SocketAddress(String hostname) {
        this(hostname, -1);
    }

    public SocketAddress(int port) {
        this(null, port);
    }

    public SocketAddress(String hostname, int port) {
        if (hostname != null && (hostname.contains("[") || hostname.contains("]"))) {
            throw new IllegalArgumentException("hostname cannot contain '[' or ']'");
        }
        this.hostname = hostname != null ? hostname : "";
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress socketAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public boolean isWildcard() {
        return WILDCARDS.contains(this.hostname);
    }

    public boolean isIPv6() {
        return SocketAddress.isHostnameIPv6(this.hostname);
    }

    public String toString() {
        return SocketAddress.format(this.hostname, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddress that = (SocketAddress)o;
        return this.port == that.port && Objects.equals(this.hostname, that.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port);
    }

    public static String format(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return SocketAddress.format(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return address == null ? "" : address.toString();
    }

    public static String format(String hostname, int port) {
        String portStr = port >= 0 ? String.format(":%s", port) : "";
        String hostnameStr = "";
        if (hostname != null) {
            hostnameStr = SocketAddress.isHostnameIPv6(hostname) ? String.format("[%s]", hostname) : hostname;
        }
        return hostnameStr + portStr;
    }

    private static boolean isHostnameIPv6(String hostname) {
        return hostname.contains(":");
    }
}

