/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

class RecordSet<R extends AbstractBaseRecord>
implements Iterable<R> {
    private final Map<Long, R> map = new HashMap<Long, R>();

    RecordSet() {
    }

    void add(R record) {
        this.map.put(record.getId(), record);
    }

    RecordSet<R> union(RecordSet<R> other) {
        RecordSet<R> set = new RecordSet<R>();
        set.addAll(this);
        set.addAll(other);
        return set;
    }

    int size() {
        return this.map.size();
    }

    @Override
    public Iterator<R> iterator() {
        return this.map.values().iterator();
    }

    public void addAll(RecordSet<R> other) {
        for (AbstractBaseRecord record : other.map.values()) {
            this.add(record);
        }
    }

    public boolean containsAll(RecordSet<R> other) {
        for (Long id : other.map.keySet()) {
            if (this.map.containsKey(id)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[\n");
        for (AbstractBaseRecord r : this.map.values()) {
            builder.append(r.toString()).append(",\n");
        }
        return builder.append("]\n").toString();
    }

    public static <R extends AbstractBaseRecord> RecordSet<R> asSet(R ... records) {
        RecordSet<R> set = new RecordSet<R>();
        for (R record : records) {
            set.add(record);
        }
        return set;
    }
}

