/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Iterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class CloningRecordIterator<R extends AbstractBaseRecord>
extends PrefetchingResourceIterator<R> {
    private final Iterator<R> actualIterator;

    public CloningRecordIterator(Iterator<R> actualIterator) {
        this.actualIterator = actualIterator;
    }

    protected R fetchNextOrNull() {
        return (R)(this.actualIterator.hasNext() ? ((AbstractBaseRecord)this.actualIterator.next()).clone() : null);
    }

    public void close() {
        if (this.actualIterator instanceof Resource) {
            ((Resource)this.actualIterator).close();
        }
    }

    public static <R extends AbstractBaseRecord> Iterator<R> cloned(Iterator<R> iterator) {
        return new CloningRecordIterator<R>(iterator);
    }
}

