/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.consistency.checker.NodeLink;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

enum RelationshipLink {
    SOURCE_PREV{

        @Override
        boolean endOfChain(RelationshipRecord relationship) {
            return relationship.isFirstInFirstChain();
        }

        @Override
        long node(RelationshipRecord relationship) {
            return relationship.getFirstNode();
        }

        @Override
        long link(RelationshipRecord relationship) {
            return relationship.getFirstPrevRel();
        }

        @Override
        void setOther(RelationshipRecord relationship, NodeLink nodeLink, long other) {
            nodeLink.setNextRel(relationship, other);
        }

        @Override
        long other(RelationshipRecord relationship, NodeLink nodeLink) {
            return nodeLink.getNextRel(relationship);
        }

        @Override
        void reportDoesNotReferenceBack(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).sourcePrevDoesNotReferenceBack(other);
        }

        @Override
        void reportNotUsedRelationshipReferencedInChain(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).notUsedRelationshipReferencedInChain(relationship);
        }

        @Override
        void reportOtherNode(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).sourcePrevReferencesOtherNodes(other);
        }
    }
    ,
    SOURCE_NEXT{

        @Override
        boolean endOfChain(RelationshipRecord relationship) {
            return Record.NULL_REFERENCE.is(relationship.getFirstNextRel());
        }

        @Override
        long node(RelationshipRecord relationship) {
            return relationship.getFirstNode();
        }

        @Override
        long link(RelationshipRecord relationship) {
            return relationship.getFirstNextRel();
        }

        @Override
        void setOther(RelationshipRecord relationship, NodeLink nodeLink, long other) {
            nodeLink.setPrevRel(relationship, other);
        }

        @Override
        long other(RelationshipRecord relationship, NodeLink nodeLink) {
            return nodeLink.getPrevRel(relationship);
        }

        @Override
        void reportDoesNotReferenceBack(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).sourceNextDoesNotReferenceBack(other);
        }

        @Override
        void reportNotUsedRelationshipReferencedInChain(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).notUsedRelationshipReferencedInChain(relationship);
        }

        @Override
        void reportOtherNode(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).sourceNextReferencesOtherNodes(other);
        }
    }
    ,
    TARGET_PREV{

        @Override
        boolean endOfChain(RelationshipRecord relationship) {
            return relationship.isFirstInSecondChain();
        }

        @Override
        long node(RelationshipRecord relationship) {
            return relationship.getSecondNode();
        }

        @Override
        long link(RelationshipRecord relationship) {
            return relationship.getSecondPrevRel();
        }

        @Override
        void setOther(RelationshipRecord relationship, NodeLink nodeLink, long other) {
            nodeLink.setNextRel(relationship, other);
        }

        @Override
        long other(RelationshipRecord relationship, NodeLink nodeLink) {
            return nodeLink.getNextRel(relationship);
        }

        @Override
        void reportDoesNotReferenceBack(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).targetPrevDoesNotReferenceBack(other);
        }

        @Override
        void reportNotUsedRelationshipReferencedInChain(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).notUsedRelationshipReferencedInChain(relationship);
        }

        @Override
        void reportOtherNode(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).targetPrevReferencesOtherNodes(other);
        }
    }
    ,
    TARGET_NEXT{

        @Override
        boolean endOfChain(RelationshipRecord relationship) {
            return Record.NULL_REFERENCE.is(relationship.getSecondNextRel());
        }

        @Override
        long node(RelationshipRecord relationship) {
            return relationship.getSecondNode();
        }

        @Override
        long link(RelationshipRecord relationship) {
            return relationship.getSecondNextRel();
        }

        @Override
        void setOther(RelationshipRecord relationship, NodeLink nodeLink, long other) {
            nodeLink.setPrevRel(relationship, other);
        }

        @Override
        long other(RelationshipRecord relationship, NodeLink nodeLink) {
            return nodeLink.getPrevRel(relationship);
        }

        @Override
        void reportDoesNotReferenceBack(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).targetNextDoesNotReferenceBack(other);
        }

        @Override
        void reportNotUsedRelationshipReferencedInChain(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).notUsedRelationshipReferencedInChain(relationship);
        }

        @Override
        void reportOtherNode(ConsistencyReport.Reporter reporter, RelationshipRecord relationship, RelationshipRecord other) {
            reporter.forRelationship(relationship).targetNextReferencesOtherNodes(other);
        }
    };


    abstract boolean endOfChain(RelationshipRecord var1);

    abstract long node(RelationshipRecord var1);

    abstract long link(RelationshipRecord var1);

    abstract void setOther(RelationshipRecord var1, NodeLink var2, long var3);

    abstract long other(RelationshipRecord var1, NodeLink var2);

    abstract void reportDoesNotReferenceBack(ConsistencyReport.Reporter var1, RelationshipRecord var2, RelationshipRecord var3);

    abstract void reportNotUsedRelationshipReferencedInChain(ConsistencyReport.Reporter var1, RelationshipRecord var2, RelationshipRecord var3);

    abstract void reportOtherNode(ConsistencyReport.Reporter var1, RelationshipRecord var2, RelationshipRecord var3);
}

