/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.neo4j.consistency.checking.ByteArrayBitsManipulator;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.util.concurrent.Futures;

class PackedMultiFieldCache {
    private final ByteArray array;
    private ByteArrayBitsManipulator slots;
    private long[] initValues;

    PackedMultiFieldCache(ByteArray array, int ... slotSizes) {
        this.array = array;
        this.setSlotSizes(slotSizes);
    }

    void put(long index, long ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.slots.set(this.array, index, i, values[i]);
        }
    }

    void put(long index, int slot, long value) {
        this.slots.set(this.array, index, slot, value);
    }

    long get(long index, int slot) {
        if (index < this.array.length()) {
            return this.slots.get(this.array, index, slot);
        }
        return this.initValues[slot];
    }

    void setSlotSizes(int ... slotSizes) {
        this.slots = new ByteArrayBitsManipulator(slotSizes);
        this.initValues = PackedMultiFieldCache.getInitVals(slotSizes);
    }

    void clear() {
        long length = this.array.length();
        for (long i = 0L; i < length; ++i) {
            this.clear(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearParallel(int numThreads) {
        long length = this.array.length();
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        long numPerThread = length / (long)numThreads;
        long prevLowIndex = 0L;
        for (int i = 0; i < numThreads; ++i) {
            long lowIndex = prevLowIndex;
            long highIndex = i == numThreads - 1 ? length : lowIndex + numPerThread;
            tasks.add(() -> {
                for (long index = lowIndex; index < highIndex; ++index) {
                    this.clear(index);
                }
                return null;
            });
            prevLowIndex = highIndex;
        }
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            Futures.getAllResults(executor.invokeAll(tasks));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            executor.shutdown();
        }
    }

    void clear(long index) {
        this.put(index, this.initValues);
    }

    private static long[] getInitVals(int[] slotSizes) {
        long[] initVals = new long[slotSizes.length];
        for (int i = 0; i < initVals.length; ++i) {
            initVals[i] = PackedMultiFieldCache.isId(slotSizes, i) ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : 0L;
        }
        return initVals;
    }

    private static boolean isId(int[] slotSizes, int i) {
        return slotSizes[i] >= 40;
    }
}

