/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.nio.file.Path;
import org.neo4j.cli.Converters;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.internal.helpers.MathUtil;
import picocli.CommandLine;

public class ConsistencyCheckOptions {
    @CommandLine.Option(names={"--check-indexes"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Perform consistency checks on indexes."})
    private boolean checkIndexes = ConsistencyFlags.DEFAULT.checkIndexes();
    @CommandLine.Option(names={"--check-graph"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="true|false", fallbackValue="true", description={"Perform consistency checks between nodes, relationships, properties, types, and tokens.%n  Default: true"})
    private Boolean checkGraph;
    @CommandLine.Option(names={"--check-counts"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="true|false", fallbackValue="true", description={"Perform consistency checks on the counts. Requires <check-graph>, and may implicitly enable <check-graph> if it were not explicitly disabled.%n  Default: <check-graph>"})
    private boolean checkCounts = ConsistencyFlags.DEFAULT.checkCounts();
    @CommandLine.Option(names={"--check-property-owners"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Perform consistency checks on the ownership of properties. Requires <check-graph>, and may implicitly enable <check-graph> if it were not explicitly disabled."})
    private boolean checkPropertyOwners = ConsistencyFlags.DEFAULT.checkPropertyOwners();
    @CommandLine.Option(names={"--report-path"}, paramLabel="<path>", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"Path to where a consistency report will be written. Interpreted as a directory, unless it has an extension of '.report'."})
    private Path reportPath = Path.of(".", new String[0]);
    @CommandLine.Option(names={"--max-off-heap-memory"}, paramLabel="<size>", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, defaultValue="90%", converter={Converters.MaxOffHeapMemoryConverter.class}, description={"Maximum memory that neo4j-admin can use for page cache and various caching data structures to improve performance. Value can be plain numbers, like 10000000 or e.g. 20G for 20 gigabytes, or even e.g. 70%%, which will amount to 70%% of currently free memory on the machine."})
    private long maxOffHeapMemory;
    @CommandLine.Option(names={"--threads"}, paramLabel="<number of threads>", defaultValue="all", showDefaultValue=CommandLine.Help.Visibility.NEVER, converter={NumberOfThreadsConverter.class}, description={"Number of threads used to check the consistency. Default: The number of CPUs on the machine."})
    private int numberOfThreads;

    private boolean checkGraph() {
        return this.checkGraph == null ? ConsistencyFlags.DEFAULT.checkGraph() || this.checkCounts || this.checkPropertyOwners : this.checkGraph;
    }

    public Path reportPath() {
        return this.reportPath.normalize();
    }

    private IllegalArgumentException validateGraphOptions() {
        if (this.checkGraph == null || this.checkGraph.booleanValue()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String error = "<%%s> cannot be %%s if <%s> is explicitly set to %s".formatted("check-graph", false);
        if (this.checkCounts) {
            sb.append(error.formatted("check-counts", true));
        }
        if (this.checkPropertyOwners) {
            sb.append(error.formatted("check-property-owners", true));
        }
        return !sb.isEmpty() ? new IllegalArgumentException(sb.toString()) : null;
    }

    public long maxOffHeapMemory() {
        return this.maxOffHeapMemory;
    }

    public int numberOfThreads() {
        return this.numberOfThreads;
    }

    public ConsistencyFlags toFlags() {
        return this.toFlags(false);
    }

    public ConsistencyFlags toFlags(boolean force) {
        IllegalArgumentException invalidGraphOptions = this.validateGraphOptions();
        if (!force && invalidGraphOptions != null) {
            throw invalidGraphOptions;
        }
        boolean checkGraphForce = force || this.checkGraph();
        boolean checkCountsForce = checkGraphForce && this.checkCounts;
        boolean checkPropertyOwnersForce = checkGraphForce && this.checkPropertyOwners;
        return new ConsistencyFlags(this.checkIndexes, checkGraphForce, checkCountsForce, checkPropertyOwnersForce);
    }

    private static class NumberOfThreadsConverter
    implements CommandLine.ITypeConverter<Integer> {
        private NumberOfThreadsConverter() {
        }

        public Integer convert(String value) throws Exception {
            if ("all".equals(value)) {
                return Runtime.getRuntime().availableProcessors();
            }
            return MathUtil.clamp((int)Integer.parseInt(value), (int)1, (int)Runtime.getRuntime().availableProcessors());
        }
    }
}

