/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.OptionalInt;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.NewLineChunker;

public class MultiLineChunker
extends NewLineChunker {
    private final char delimiter;
    private final char quotationCharacter;

    public MultiLineChunker(CharReadable reader, Configuration config, HeaderSkipper headerSkip) {
        super(reader, config.bufferSize(), headerSkip);
        this.delimiter = config.delimiter();
        this.quotationCharacter = config.quotationCharacter();
    }

    @Override
    protected int offsetOfLastRow(char[] buffer) {
        LinkedList<ParseState> states = new LinkedList<ParseState>();
        states.push(ParseState.endOfBuffer(buffer));
        int pos = ((ParseState)states.peek()).offset;
        while (pos >= 0) {
            if (this.isEscapedQuote(buffer, pos)) {
                pos -= 2;
                continue;
            }
            if (this.isCellBoundary(buffer, pos)) {
                if (this.isDelimiter(buffer, --pos)) {
                    states.push(ParseState.startText(pos + 1));
                    states.push(ParseState.delimiter(pos--));
                    if (this.isCellBoundary(buffer, pos)) {
                        states.push(ParseState.endText(pos--));
                        continue;
                    }
                    states.push(ParseState.endOthers(pos));
                    continue;
                }
                switch (states.peek().state) {
                    case END_TEXT_CELL: {
                        states.push(ParseState.startText(pos + 1));
                        break;
                    }
                    case END_OTHER_CELLS: {
                        states.push(ParseState.startOthers(pos + 1));
                        break;
                    }
                    case DELIMITER: 
                    case EOB: {
                        states.push(ParseState.endText(pos + 1));
                        break;
                    }
                    case CR: {
                        int currentPos = pos;
                        return MultiLineChunker.scanBackForCRAfterQuote(states).orElseThrow(() -> this.error("reached floating quote", currentPos));
                    }
                    case START_OTHER_CELLS: 
                    case START_TEXT_CELL: {
                        throw this.error("reached floating quote", pos);
                    }
                }
                continue;
            }
            if (this.isDelimiter(buffer, pos)) {
                --pos;
                switch (states.peek().state) {
                    case EOB: 
                    case CR: {
                        states.push(ParseState.delimiter(pos + 1));
                        break;
                    }
                    case END_OTHER_CELLS: {
                        states.push(ParseState.startOthers(pos + 2));
                        states.push(ParseState.delimiter(pos + 1));
                        if (this.isCellBoundary(buffer, pos)) {
                            states.push(ParseState.endText(pos--));
                            break;
                        }
                        states.push(ParseState.endOthers(pos));
                        break;
                    }
                    case START_OTHER_CELLS: 
                    case START_TEXT_CELL: {
                        states.push(ParseState.delimiter(pos + 1));
                        if (this.isCellBoundary(buffer, pos)) {
                            states.push(ParseState.endText(pos--));
                            break;
                        }
                        states.push(ParseState.endOthers(pos));
                    }
                }
                continue;
            }
            int cr = MultiLineChunker.checkForCR(buffer, pos);
            if (cr == 0) {
                --pos;
                continue;
            }
            int posAfterCR = pos;
            pos -= cr;
            switch (states.peek().state) {
                case EOB: {
                    states.push(ParseState.newline(posAfterCR));
                    break;
                }
                case DELIMITER: 
                case CR: {
                    this.ensureInTextCellForCR(states, posAfterCR);
                    break;
                }
                case START_OTHER_CELLS: 
                case START_TEXT_CELL: {
                    throw this.error("found CR outside a text cell", posAfterCR);
                }
                case END_OTHER_CELLS: {
                    return posAfterCR;
                }
            }
        }
        return MultiLineChunker.scanBackForCRAfterEnds(states).orElseThrow(() -> this.error("reached beginning with no previous CR", 0));
    }

    private static OptionalInt scanBackForCRAfterQuote(LinkedList<ParseState> states) {
        if (states.size() >= 2) {
            Iterator iterator = states.iterator();
            ParseState parseState = (ParseState)iterator.next();
            if (parseState.state == ReadState.CR) {
                int crPos = parseState.offset;
                boolean mismatched = false;
                while (iterator.hasNext()) {
                    parseState = (ParseState)iterator.next();
                    if (parseState.state == ReadState.DELIMITER || parseState.state == ReadState.EOB) continue;
                    mismatched = true;
                    break;
                }
                if (!mismatched) {
                    return OptionalInt.of(crPos);
                }
            }
        }
        return OptionalInt.empty();
    }

    private static OptionalInt scanBackForCRAfterEnds(LinkedList<ParseState> states) {
        ReadState previous = null;
        for (ParseState parseState : states) {
            ReadState state = parseState.state;
            if (state == ReadState.CR && (previous == ReadState.END_OTHER_CELLS || previous == ReadState.END_TEXT_CELL)) {
                return OptionalInt.of(parseState.offset);
            }
            previous = state;
        }
        return OptionalInt.empty();
    }

    private void ensureInTextCellForCR(LinkedList<ParseState> states, int pos) {
        ReadState state = states.stream().map(ParseState::state).filter(s -> s != ReadState.CR && s != ReadState.DELIMITER).findFirst().orElseThrow();
        if (state != ReadState.END_TEXT_CELL && state != ReadState.EOB) {
            throw this.error("found CR outside of a text cell", pos);
        }
        states.push(ParseState.newline(pos));
    }

    private IllegalStateException error(String message, int position) {
        return new IllegalStateException("Weird input data, %s at position %d of buffer of length %d, not supported a.t.m.".formatted(message, position, this.chunkSize));
    }

    private boolean isDelimiter(char[] buffer, int offset) {
        return buffer[offset] == this.delimiter;
    }

    private boolean isCellBoundary(char[] buffer, int offset) {
        if (buffer[offset] == this.quotationCharacter) {
            return offset == 0 || !this.isQuoteEscapeChar(buffer, offset - 1);
        }
        return false;
    }

    private boolean isEscapedQuote(char[] buffer, int offset) {
        if (offset > 0 && buffer[offset] == this.quotationCharacter) {
            return this.isQuoteEscapeChar(buffer, offset - 1);
        }
        return false;
    }

    private boolean isQuoteEscapeChar(char[] buffer, int offset) {
        return buffer[offset] == '\\' || buffer[offset] == this.quotationCharacter;
    }

    private static int checkForCR(char[] buffer, int offset) {
        if (buffer[offset] == '\n') {
            return offset == 0 || buffer[offset - 1] != '\r' ? 1 : 2;
        }
        return 0;
    }

    private record ParseState(int offset, ReadState state) {
        private static ParseState endOfBuffer(char[] buffer) {
            return new ParseState(buffer.length - 1, ReadState.EOB);
        }

        private static ParseState delimiter(int pos) {
            return new ParseState(pos, ReadState.DELIMITER);
        }

        private static ParseState newline(int pos) {
            return new ParseState(pos, ReadState.CR);
        }

        private static ParseState startText(int pos) {
            return new ParseState(pos, ReadState.START_TEXT_CELL);
        }

        private static ParseState endText(int pos) {
            return new ParseState(pos, ReadState.END_TEXT_CELL);
        }

        private static ParseState startOthers(int pos) {
            return new ParseState(pos, ReadState.START_OTHER_CELLS);
        }

        private static ParseState endOthers(int pos) {
            return new ParseState(pos, ReadState.END_OTHER_CELLS);
        }
    }

    private static enum ReadState {
        EOB,
        DELIMITER,
        START_TEXT_CELL,
        END_TEXT_CELL,
        START_OTHER_CELLS,
        END_OTHER_CELLS,
        CR;

    }
}

