/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.query.BinaryPredicateExpression;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.PredicateExpression;
import org.neo4j.cypherdsl.query.Query;

public class FunctionExpression
extends Expression {
    public String name;
    public Expression expression;

    public BinaryPredicateExpression eq(Object value) {
        return this.binaryPredicate("=", value);
    }

    public BinaryPredicateExpression gt(Object value) {
        return this.binaryPredicate(">", value);
    }

    public BinaryPredicateExpression lt(Object value) {
        return this.binaryPredicate("<", value);
    }

    public BinaryPredicateExpression gte(Object value) {
        return this.binaryPredicate(">=", value);
    }

    public BinaryPredicateExpression lte(Object value) {
        return this.binaryPredicate(">=", value);
    }

    public BinaryPredicateExpression ne(Object value) {
        return this.binaryPredicate("<>", value);
    }

    private BinaryPredicateExpression binaryPredicate(String operator, Object value) {
        Query.checkNull(value, "Value");
        BinaryPredicateExpression binaryPredicateExpression = new BinaryPredicateExpression();
        binaryPredicateExpression.operator = operator;
        binaryPredicateExpression.left = this;
        binaryPredicateExpression.right = value instanceof Expression ? (Expression)value : CypherQuery.literal(value);
        return binaryPredicateExpression;
    }

    @Override
    public void asString(StringBuilder builder) {
        builder.append(this.name).append('(');
        this.expression.asString(builder);
        builder.append(')');
    }

    public static class Filter
    extends Expression {
        public Identifier name;
        public Expression iterable;
        public PredicateExpression predicate;

        @Override
        public void asString(StringBuilder builder) {
            builder.append("filter").append('(');
            this.name.asString(builder);
            builder.append(" IN ");
            this.iterable.asString(builder);
            builder.append(":");
            this.predicate.asString(builder);
            builder.append(')');
        }
    }

    public static class Extract
    extends Expression {
        public Identifier name;
        public Expression iterable;
        public Expression expression;

        @Override
        public void asString(StringBuilder builder) {
            builder.append("extract").append('(');
            this.name.asString(builder);
            builder.append(" IN ");
            this.iterable.asString(builder);
            builder.append(":");
            this.expression.asString(builder);
            builder.append(')');
        }
    }

    public static class Expressions
    extends Expression {
        public Expression[] expressions;

        @Override
        public void asString(StringBuilder builder) {
            for (int i = 0; i < this.expressions.length; ++i) {
                Expression expression = this.expressions[i];
                if (i > 0) {
                    builder.append(',');
                }
                expression.asString(builder);
            }
        }
    }
}

