/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.util.regex.Pattern;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.query.BinaryPredicateExpression;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Has;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.IsNotNull;
import org.neo4j.cypherdsl.query.IsNull;
import org.neo4j.cypherdsl.query.NullHandling;
import org.neo4j.cypherdsl.query.Query;

public abstract class Property<TYPE extends Property>
extends Expression {
    private static Pattern simpleName = Pattern.compile("\\w*");
    protected Identifier owner;
    public Identifier name;
    protected NullHandling nullHandling = NullHandling.NULL;

    public TYPE falseIfMissing() {
        this.nullHandling = NullHandling.FALSE_IF_MISSING;
        return (TYPE)this;
    }

    public TYPE trueIfMissing() {
        this.nullHandling = NullHandling.TRUE_IF_MISSING;
        return (TYPE)this;
    }

    public TYPE optional() {
        this.nullHandling = NullHandling.TRUE_IF_MISSING;
        return (TYPE)this;
    }

    public BinaryPredicateExpression eq(Object value) {
        return this.binaryPredicate("=", value);
    }

    public BinaryPredicateExpression gt(Object value) {
        return this.binaryPredicate(">", value);
    }

    public BinaryPredicateExpression lt(Object value) {
        return this.binaryPredicate("<", value);
    }

    public BinaryPredicateExpression gte(Object value) {
        return this.binaryPredicate(">=", value);
    }

    public BinaryPredicateExpression lte(Object value) {
        return this.binaryPredicate(">=", value);
    }

    public BinaryPredicateExpression ne(Object value) {
        return this.binaryPredicate("<>", value);
    }

    public Has has() {
        Has has = new Has();
        has.expression = this;
        return has;
    }

    public IsNull isNull() {
        IsNull isNull = new IsNull();
        isNull.expression = this;
        return isNull;
    }

    public IsNotNull isNotNull() {
        IsNotNull isNotNull = new IsNotNull();
        isNotNull.expression = this;
        return isNotNull;
    }

    @Override
    public void asString(StringBuilder builder) {
        if (this.owner != null) {
            this.owner.asString(builder);
            builder.append('.');
        }
        this.name.asString(builder);
        NullHandling nullHandling1 = this.nullHandling;
        nullHandling1.asString(builder);
    }

    private BinaryPredicateExpression binaryPredicate(String operator, Object value) {
        Query.checkNull(value, "Value");
        BinaryPredicateExpression binaryPredicateExpression = new BinaryPredicateExpression();
        binaryPredicateExpression.operator = operator;
        binaryPredicateExpression.left = this;
        binaryPredicateExpression.right = value instanceof Expression ? (Expression)value : CypherQuery.literal(value);
        return binaryPredicateExpression;
    }
}

