/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.query.Direction;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.PredicateExpression;

public abstract class WhereExpression
extends PredicateExpression {

    public static class WhereIn
    extends PredicateExpression {
        public Expression expression;
        public Expression[] elements;

        @Override
        public void asString(StringBuilder builder) {
            this.expression.asString(builder);
            builder.append(" IN [");
            for (int i = 0; i < this.elements.length; ++i) {
                Expression element = this.elements[i];
                if (i > 0) {
                    builder.append(",");
                }
                element.asString(builder);
            }
            builder.append("]");
        }
    }

    public static class WhereRelationship
    extends PredicateExpression {
        public String from = "";
        public String to = "";
        public Direction direction = Direction.BOTH;
        public String[] relationships = new String[0];
        public Integer minHops;
        public Integer maxHops;

        @Override
        public void asString(StringBuilder builder) {
            builder.append('(').append(this.from).append(')');
            builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
            if (this.relationships.length > 0 || this.minHops != null || this.maxHops != null) {
                builder.append('[');
                if (this.relationships.length > 0) {
                    builder.append(':');
                    for (int i = 0; i < this.relationships.length; ++i) {
                        String rel = this.relationships[i];
                        if (i > 0) {
                            builder.append("|");
                        }
                        builder.append(rel);
                    }
                }
                if (this.minHops != null || this.maxHops != null) {
                    builder.append('*');
                    if (this.minHops != null) {
                        builder.append(this.minHops);
                    }
                    builder.append("..");
                    if (this.maxHops != null) {
                        builder.append(this.maxHops);
                    }
                }
                builder.append(']');
            }
            builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
            builder.append('(').append(this.to).append(')');
        }

        public WhereRelationship out(String ... relationship) {
            this.direction = Direction.OUT;
            this.relationships = relationship;
            return this;
        }

        public WhereRelationship in(String ... relationship) {
            this.direction = Direction.IN;
            this.relationships = relationship;
            return this;
        }

        public WhereRelationship both(String ... relationship) {
            this.direction = Direction.BOTH;
            this.relationships = relationship;
            return this;
        }

        public WhereRelationship hops(Integer minHops, Integer maxHops) {
            if (minHops != null && minHops < 0) {
                throw new IllegalArgumentException("Minimum number of hops must be over zero");
            }
            if (maxHops != null && maxHops < 0) {
                throw new IllegalArgumentException("Maximum number of hops must be over zero");
            }
            this.minHops = minHops;
            this.maxHops = maxHops;
            return this;
        }

        public WhereRelationship from(String from) {
            this.from = from;
            return this;
        }

        public WhereRelationship to(String to) {
            this.to = to;
            return this;
        }
    }
}

