/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.querydsl;

import com.mysema.query.lucene.LuceneSerializer;
import com.mysema.query.types.Constant;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;
import java.util.Collections;
import javax.annotation.Nullable;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Return;
import org.neo4j.cypherdsl.query.BooleanExpression;
import org.neo4j.cypherdsl.query.Expression;
import org.neo4j.cypherdsl.query.Identifier;
import org.neo4j.cypherdsl.query.Literal;
import org.neo4j.cypherdsl.query.MatchExpression;
import org.neo4j.cypherdsl.query.NumberProperty;
import org.neo4j.cypherdsl.query.PredicateExpression;
import org.neo4j.cypherdsl.query.Property;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.StartExpression;
import org.neo4j.cypherdsl.query.StringProperty;
import org.neo4j.cypherdsl.querydsl.QueryDSLMatch;
import org.neo4j.cypherdsl.querydsl.QueryDSLMatchExpression;
import org.neo4j.cypherdsl.querydsl.QueryDSLWhere;

public class CypherQueryDSL
extends CypherQuery {
    private static final LuceneSerializer luceneSerializer = new LuceneSerializer(true, true);

    public static QueryDSLMatch start(StartExpression ... startExpression) {
        CypherQueryDSL query = new CypherQueryDSL();
        return query.starts(startExpression);
    }

    @Override
    public QueryDSLMatch starts(StartExpression ... startExpression) {
        Collections.addAll(this.query.startExpressions, startExpression);
        return new QueryDSLGrammar();
    }

    @Override
    public QueryDSLMatch starts(Iterable<StartExpression> startExpression) {
        for (StartExpression expression : startExpression) {
            this.query.startExpressions.add(expression);
        }
        return new QueryDSLGrammar();
    }

    public static Identifier identifier(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.toString());
    }

    public static Property property(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).property(entityPath.getMetadata().getExpression().toString());
    }

    public static StringProperty string(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).string(entityPath.getMetadata().getExpression().toString());
    }

    public static NumberProperty number(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).number(entityPath.getMetadata().getExpression().toString());
    }

    public static StartExpression.StartNodesQuery query(Path<?> entity, String indexName, Predicate query) {
        return CypherQueryDSL.query(entity.toString(), indexName, query);
    }

    public static StartExpression.StartNodesQuery query(String name, String indexName, Predicate query) {
        return CypherQueryDSL.query(name, indexName, luceneSerializer.toQuery((com.mysema.query.types.Expression)query, null).toString());
    }

    public static StartExpression.StartNodes node(Path<?> entity, long ... id) {
        return CypherQuery.node(entity.toString(), id);
    }

    public static StartExpression.StartNodes node(Path<?> entity, String parameter) {
        return CypherQuery.node(entity.toString(), parameter);
    }

    public static StartExpression.StartNodesLookup lookup(Path<?> entity, String indexName, Path<?> key, String value) {
        return CypherQuery.lookup(entity.toString(), indexName, key.getMetadata().getExpression().toString(), value);
    }

    public static StartExpression.StartNodesLookup lookup(Path<?> entity, String indexName, Identifier key, Literal value) {
        return CypherQuery.lookup(CypherQueryDSL.identifier(entity.toString()), CypherQueryDSL.identifier(indexName), key, value);
    }

    public static QueryDSLMatchExpression.QueryDSLPath path() {
        return new QueryDSLMatchExpression.QueryDSLPath();
    }

    public static QueryDSLMatchExpression.QueryDSLPath path(String name) {
        return CypherQueryDSL.path(CypherQueryDSL.identifier(name));
    }

    public static QueryDSLMatchExpression.QueryDSLPath path(Identifier name) {
        Query.checkNull(name, "Name");
        QueryDSLMatchExpression.QueryDSLPath path = new QueryDSLMatchExpression.QueryDSLPath();
        path.pathName = name;
        return path;
    }

    public static QueryDSLMatchExpression.QueryDSLFunctionPath shortestPath(String name) {
        return CypherQueryDSL.shortestPath(CypherQueryDSL.identifier(name));
    }

    public static QueryDSLMatchExpression.QueryDSLFunctionPath shortestPath(Identifier name) {
        Query.checkNull(name, "Name");
        QueryDSLMatchExpression.QueryDSLFunctionPath functionPath = new QueryDSLMatchExpression.QueryDSLFunctionPath();
        functionPath.function = "shortestPath";
        functionPath.pathName = name;
        return functionPath;
    }

    private class QueryDSLGrammar
    extends CypherQuery.Grammar
    implements QueryDSLMatch,
    QueryDSLWhere {
        private QueryDSLGrammar() {
        }

        @Override
        public QueryDSLMatch match(MatchExpression ... expression) {
            return (QueryDSLMatch)super.match(expression);
        }

        @Override
        public QueryDSLMatch match(Iterable<MatchExpression> expressions) {
            return (QueryDSLMatch)super.match(expressions);
        }

        @Override
        public Return where(Predicate predicate) {
            ((CypherQueryDSL)CypherQueryDSL.this).query.whereExpressions.add((PredicateExpression)predicate.accept((Visitor)new Visitor<PredicateExpression, BooleanExpression>(){

                public PredicateExpression visit(Constant<?> constant, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public PredicateExpression visit(FactoryExpression<?> factoryExpression, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public PredicateExpression visit(Operation<?> operation, @Nullable BooleanExpression booleanExpression) {
                    String id = operation.getOperator().getId();
                    if (id.equals(Ops.AND.getId())) {
                        return CypherQuery.and((PredicateExpression)operation.getArg(0).accept((Visitor)this, null), (PredicateExpression)operation.getArg(1).accept((Visitor)this, null));
                    }
                    if (id.equals(Ops.OR.getId())) {
                        return CypherQuery.or((PredicateExpression)operation.getArg(0).accept((Visitor)this, null), (PredicateExpression)operation.getArg(1).accept((Visitor)this, null));
                    }
                    if (id.equals(Ops.NOT.getId())) {
                        return CypherQuery.not((PredicateExpression)operation.getArg(0).accept((Visitor)this, null));
                    }
                    if (id.equals(Ops.EQ_PRIMITIVE.getId()) || id.equals(Ops.EQ_OBJECT.getId())) {
                        return CypherQuery.eq(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.NE_PRIMITIVE.getId()) || id.equals(Ops.NE_OBJECT.getId())) {
                        return CypherQuery.ne(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.GT.getId())) {
                        return CypherQuery.gt(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.LT.getId())) {
                        return CypherQuery.lt(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.GOE.getId())) {
                        return CypherQuery.gte(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.LOE.getId())) {
                        return CypherQuery.lte(this.arg(operation.getArg(0)), this.arg(operation.getArg(1)));
                    }
                    if (id.equals(Ops.EXISTS.getId())) {
                        return CypherQueryDSL.this.has((Expression)this.arg(operation.getArg(0)));
                    }
                    if (id.equals(Ops.IS_NULL.getId())) {
                        return CypherQueryDSL.this.isNull((Expression)this.arg(operation.getArg(0)));
                    }
                    if (id.equals(Ops.IS_NOT_NULL.getId())) {
                        return CypherQueryDSL.this.isNotNull((Expression)this.arg(operation.getArg(0)));
                    }
                    throw new IllegalArgumentException("Unknown operator:" + id + " in expression " + operation);
                }

                public BooleanExpression visit(ParamExpression<?> paramExpression, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public BooleanExpression visit(Path<?> path, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public BooleanExpression visit(SubQueryExpression<?> subQueryExpression, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public BooleanExpression visit(TemplateExpression<?> templateExpression, @Nullable BooleanExpression booleanExpression) {
                    return null;
                }

                public Object arg(com.mysema.query.types.Expression expression) {
                    if (expression instanceof Constant) {
                        return ((Constant)expression).getConstant();
                    }
                    if (expression instanceof ParamExpression) {
                        return CypherQuery.param(((ParamExpression)expression).getName());
                    }
                    if (expression instanceof Path) {
                        Path path = (Path)expression;
                        return CypherQueryDSL.identifier(path.getRoot()).string(path.getMetadata().getExpression().toString());
                    }
                    throw new IllegalArgumentException("Unknown argument type:" + expression);
                }
            }, null));
            return this;
        }
    }
}

