/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Namespace;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.INTERNAL, since="2020.0.1")
public final class ProcedureName
implements Visitable {
    private final Namespace optionalNamespace;
    private final String value;

    static ProcedureName from(String ... namespaceAndProcedure) {
        if (namespaceAndProcedure.length == 1) {
            return new ProcedureName(namespaceAndProcedure[0]);
        }
        Namespace namespace = new Namespace(Arrays.copyOf(namespaceAndProcedure, namespaceAndProcedure.length - 1));
        return new ProcedureName(namespace, namespaceAndProcedure[namespaceAndProcedure.length - 1]);
    }

    private ProcedureName(String value) {
        this(null, value);
    }

    private ProcedureName(Namespace namespace, String value) {
        this.optionalNamespace = namespace;
        this.value = value;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.optionalNamespace, visitor);
        visitor.leave(this);
    }

    public String getValue() {
        return this.value;
    }
}

