/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Property
implements Expression {
    private final Expression container;
    private final PropertyLookup name;

    static Property create(Named parentContainer, String name) {
        SymbolicName requiredSymbolicName;
        try {
            requiredSymbolicName = parentContainer.getRequiredSymbolicName();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("A property derived from a node or a relationship needs a parent with a symbolic name.");
        }
        Assertions.hasText(name, "The properties name is required.");
        return new Property(requiredSymbolicName, new PropertyLookup(name));
    }

    static Property create(Expression container, String name) {
        Assertions.notNull(container, "The property container is required.");
        Assertions.hasText(name, "The properties name is required.");
        return new Property(container, new PropertyLookup(name));
    }

    Property(Expression container, PropertyLookup name) {
        this.container = container;
        this.name = name;
    }

    @API(status=API.Status.INTERNAL)
    public PropertyLookup getName() {
        return this.name;
    }

    public Operation to(Expression expression) {
        return Operations.set(this, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.container.accept(visitor);
        this.name.accept(visitor);
        visitor.leave(this);
    }
}

