/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Merge
implements UpdatingClause {
    private static final Literal<String> BLANK = new Literal<String>(" "){

        @Override
        public String asString() {
            return (String)super.getContent();
        }
    };
    private final Pattern pattern;
    private final List<Visitable> onCreateOrMatchEvents;

    Merge(Pattern pattern) {
        this.pattern = pattern;
        this.onCreateOrMatchEvents = Collections.emptyList();
    }

    Merge(Pattern pattern, List<MergeAction> mergeActions) {
        this.pattern = pattern;
        this.onCreateOrMatchEvents = new ArrayList<Visitable>();
        this.onCreateOrMatchEvents.add(BLANK);
        this.onCreateOrMatchEvents.addAll(mergeActions);
    }

    @API(status=API.Status.INTERNAL)
    public boolean hasEvents() {
        return !this.onCreateOrMatchEvents.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.pattern.accept(visitor);
        this.onCreateOrMatchEvents.forEach(s -> s.accept(visitor));
        visitor.leave(this);
    }
}

