/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.ExposesCall;
import org.neo4j.cypherdsl.core.ExposesCreate;
import org.neo4j.cypherdsl.core.ExposesLogicalOperators;
import org.neo4j.cypherdsl.core.ExposesMatch;
import org.neo4j.cypherdsl.core.ExposesMerge;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.ExposesUnwind;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.support.Neo4jVersion;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public interface StatementBuilder
extends ExposesMatch,
ExposesCreate,
ExposesMerge,
ExposesUnwind,
ExposesReturning,
ExposesSubqueryCall {
    public OrderableOngoingReadingAndWithWithoutWhere with(String ... var1);

    public OrderableOngoingReadingAndWithWithoutWhere with(Named ... var1);

    public OrderableOngoingReadingAndWithWithoutWhere with(Expression ... var1);

    public static interface OngoingMergeAction {
        public <T extends OngoingMatchAndUpdate & BuildableStatement> T set(Expression ... var1);

        default public <T extends OngoingMatchAndUpdate & BuildableStatement> T set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }
    }

    public static interface ExposesMergeAction {
        public OngoingMergeAction onCreate();

        public OngoingMergeAction onMatch();
    }

    public static interface OngoingMatchAndUpdate
    extends ExposesReturning,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesCreate {
    }

    public static interface ExposesSetAndRemove
    extends ExposesSet {
        public <T extends OngoingMatchAndUpdate & BuildableStatement> T set(Node var1, String ... var2);

        public <T extends OngoingMatchAndUpdate & BuildableStatement> T remove(Node var1, String ... var2);

        public <T extends OngoingMatchAndUpdate & BuildableStatement> T remove(Property ... var1);
    }

    public static interface ExposesSet {
        public <T extends OngoingMatchAndUpdate & BuildableStatement> T set(Expression ... var1);

        default public <T extends OngoingMatchAndUpdate & BuildableStatement> T set(Named variable, Expression expression) {
            return this.set(variable.getRequiredSymbolicName(), expression);
        }
    }

    public static interface ExposesDelete {
        default public <T extends OngoingUpdate & BuildableStatement> T delete(String ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        default public <T extends OngoingUpdate & BuildableStatement> T delete(Named ... variables) {
            return this.delete(Expressions.createSymbolicNames(variables));
        }

        public <T extends OngoingUpdate & BuildableStatement> T delete(Expression ... var1);

        default public <T extends OngoingUpdate & BuildableStatement> T detachDelete(String ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        default public <T extends OngoingUpdate & BuildableStatement> T detachDelete(Named ... variables) {
            return this.detachDelete(Expressions.createSymbolicNames(variables));
        }

        public <T extends OngoingUpdate & BuildableStatement> T detachDelete(Expression ... var1);
    }

    public static interface ExposesUpdatingClause
    extends ExposesDelete,
    ExposesMerge,
    ExposesSetAndRemove {
    }

    public static interface ExposesLimit {
        public OngoingReadingAndWith limit(Number var1);
    }

    public static interface ExposesSkip {
        public <T extends ExposesLimit & OngoingReadingAndWith> T skip(Number var1);
    }

    public static interface ExposesOrderBy {
        public OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... var1);

        public OngoingOrderDefinition orderBy(Expression var1);
    }

    public static interface TerminalExposesLimit {
        public BuildableStatement limit(Number var1);
    }

    public static interface TerminalExposesSkip {
        public <T extends TerminalExposesLimit & BuildableStatement> T skip(Number var1);
    }

    public static interface TerminalExposesOrderBy {
        public OngoingMatchAndReturnWithOrder orderBy(SortItem ... var1);

        public TerminalOngoingOrderDefinition orderBy(Expression var1);
    }

    public static interface ExposesWith {
        default public OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
            return this.with(Expressions.createSymbolicNames(variables));
        }

        default public OrderableOngoingReadingAndWithWithoutWhere with(Named ... variables) {
            return this.with(Expressions.createSymbolicNames(variables));
        }

        public OrderableOngoingReadingAndWithWithoutWhere with(Expression ... var1);

        default public OrderableOngoingReadingAndWithWithoutWhere withDistinct(String ... variables) {
            return this.withDistinct(Expressions.createSymbolicNames(variables));
        }

        default public OrderableOngoingReadingAndWithWithoutWhere withDistinct(Named ... variables) {
            return this.withDistinct(Expressions.createSymbolicNames(variables));
        }

        public OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... var1);
    }

    public static interface BuildableStatement {
        public Statement build();

        default public Statement explain() {
            return DecoratedQuery.explain(this.build());
        }

        default public Statement profile() {
            return DecoratedQuery.profile(this.build());
        }
    }

    public static interface OngoingOrderDefinition
    extends ExposesSkip,
    ExposesLimit {
        public <T extends ExposesSkip & ExposesLimit> T descending();

        public <T extends ExposesSkip & ExposesLimit> T ascending();
    }

    public static interface OngoingReadingAndWithWithWhereAndOrder
    extends ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
        public OngoingOrderDefinition and(Expression var1);
    }

    public static interface TerminalOngoingOrderDefinition
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
        public <T extends TerminalExposesSkip & TerminalExposesLimit> T descending();

        public <T extends TerminalExposesSkip & TerminalExposesLimit> T ascending();
    }

    public static interface OngoingMatchAndReturnWithOrder
    extends TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
        public TerminalOngoingOrderDefinition and(Expression var1);
    }

    public static interface OrderableOngoingReadingAndWith
    extends ExposesOrderBy,
    ExposesSkip,
    ExposesLimit,
    OngoingReadingAndWith {
    }

    public static interface OngoingReadingAndWith
    extends OngoingReading,
    ExposesMatch {
    }

    public static interface OrderableOngoingReadingAndWithWithWhere
    extends OrderableOngoingReadingAndWith,
    ExposesLogicalOperators<OrderableOngoingReadingAndWithWithWhere> {
    }

    public static interface OrderableOngoingReadingAndWithWithoutWhere
    extends OrderableOngoingReadingAndWith {
        public OrderableOngoingReadingAndWithWithWhere where(Condition var1);

        default public OrderableOngoingReadingAndWithWithWhere where(RelationshipPattern pathPattern) {
            Assertions.notNull(pathPattern, "The path pattern must not be null.");
            return this.where(new RelationshipPatternCondition(pathPattern));
        }
    }

    public static interface OngoingReadingAndReturn
    extends TerminalExposesOrderBy,
    TerminalExposesSkip,
    TerminalExposesLimit,
    BuildableStatement {
    }

    public static interface OngoingUnwind {
        public OngoingReading as(String var1);
    }

    public static interface OngoingReading
    extends ExposesReturning,
    ExposesWith,
    ExposesUpdatingClause,
    ExposesUnwind,
    ExposesCreate,
    ExposesCall<ProcedureCall.OngoingInQueryCallWithoutArguments>,
    ExposesSubqueryCall {
    }

    public static interface OngoingReadingWithWhere
    extends OngoingReading,
    ExposesMatch,
    ExposesLogicalOperators<OngoingReadingWithWhere>,
    ExposesExistentialSubqueryCall {
    }

    public static interface OngoingReadingWithoutWhere
    extends OngoingReading,
    ExposesWhere,
    ExposesMatch,
    ExposesExistentialSubqueryCall {
    }

    public static interface ExposesExistentialSubqueryCall {
        @Neo4jVersion(minimum="4.0.0")
        public Condition asCondition();
    }

    public static interface OngoingUpdate
    extends BuildableStatement,
    ExposesCreate,
    ExposesMerge,
    ExposesDelete,
    ExposesReturning,
    ExposesWith,
    ExposesMergeAction {
    }
}

