/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="2021.0.1")
public final class Configuration {
    private static final Configuration DEFAULT_CONFIG = Configuration.newConfig().build();
    private static final Configuration PRETTY_PRINTING = Configuration.newConfig().withPrettyPrint(true).build();
    private final boolean prettyPrint;
    private final IndentStyle indentStyle;
    private final int indentSize;

    public static Configuration defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static Configuration prettyPrinting() {
        return PRETTY_PRINTING;
    }

    public static Builder newConfig() {
        return Builder.newConfig();
    }

    private Configuration(boolean prettyPrint, IndentStyle indentStyle, int indentSize) {
        this.prettyPrint = prettyPrint;
        this.indentStyle = indentStyle == null ? IndentStyle.TAB : indentStyle;
        this.indentSize = indentSize;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public IndentStyle getIndentStyle() {
        return this.indentStyle;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.prettyPrint == that.prettyPrint && this.indentSize == that.indentSize && this.indentStyle == that.indentStyle;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prettyPrint, this.indentStyle, this.indentSize});
    }

    public String toString() {
        return "Configuration{prettyPrint=" + this.prettyPrint + ", indentStyle=" + (Object)((Object)this.indentStyle) + ", indentSize=" + this.indentSize + '}';
    }

    public static final class Builder {
        private boolean prettyPrint = false;
        private IndentStyle indentStyle = IndentStyle.SPACE;
        private int indentSize = 2;

        private Builder() {
        }

        private static Builder newConfig() {
            return new Builder();
        }

        public Builder withPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder withIndentStyle(IndentStyle indentStyle) {
            this.indentStyle = indentStyle;
            return this;
        }

        public Builder withIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        public Builder but() {
            return Builder.newConfig().withPrettyPrint(this.prettyPrint).withIndentStyle(this.indentStyle).withIndentSize(this.indentSize);
        }

        public Configuration build() {
            return new Configuration(this.prettyPrint, this.indentStyle, this.indentSize);
        }
    }

    public static enum IndentStyle {
        TAB,
        SPACE;

    }
}

