/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;

class PrettyPrintingVisitor
extends DefaultVisitor {
    private final BiConsumer<StringBuilder, Integer> indentionProvider;
    private int indentationLevel;
    private int readingOrUpdatingClausesCount;

    PrettyPrintingVisitor(Configuration.IndentStyle indentStyle, int indentSize) {
        this.indentionProvider = indentStyle == Configuration.IndentStyle.TAB ? (builder, width) -> {
            for (int i = 0; i < width; ++i) {
                builder.append("\t");
            }
        } : (builder, width) -> {
            for (int i = 0; i < width * indentSize; ++i) {
                builder.append(" ");
            }
        };
    }

    private void indent(int width) {
        this.indentionProvider.accept(this.builder, width);
    }

    @Override
    void enter(Where where) {
        if (this.currentVisitedElements.stream().noneMatch(visitable -> visitable instanceof Return)) {
            this.builder.append("\nWHERE ");
        } else {
            super.enter(where);
        }
    }

    @Override
    void enter(Return returning) {
        this.trimNewline();
        super.enter(returning);
    }

    @Override
    void enter(With with) {
        this.trimNewline();
        super.enter(with);
    }

    @Override
    void enter(Set set) {
        if (this.currentVisitedElements.stream().noneMatch(visitable -> visitable instanceof MergeAction)) {
            this.trimNewline();
        }
        super.enter(set);
    }

    @Override
    void enter(Match match) {
        if (this.readingOrUpdatingClausesCount > 0) {
            this.trimNewline();
        }
        super.enter(match);
    }

    @Override
    void leave(Match match) {
        ++this.readingOrUpdatingClausesCount;
        super.leave(match);
    }

    @Override
    void enter(Create create) {
        if (this.readingOrUpdatingClausesCount > 0) {
            this.trimNewline();
        }
        super.enter(create);
    }

    @Override
    void leave(Create create) {
        ++this.readingOrUpdatingClausesCount;
        super.leave(create);
    }

    @Override
    void enter(PropertyLookup propertyLookup) {
        if (this.currentVisitedElements.stream().skip(1L).limit(1L).anyMatch(visitable -> visitable instanceof MapExpression)) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(propertyLookup);
    }

    @Override
    void enter(KeyValueMapEntry map) {
        if (this.indentationLevel > 0) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(map);
    }

    @Override
    void enter(Operator operator) {
        Operator.Type type = operator.getType();
        if (type == Operator.Type.LABEL) {
            return;
        }
        if (type != Operator.Type.PREFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
        if (operator == Operator.OR || operator == Operator.AND || operator == Operator.XOR) {
            this.trimNewline();
            this.indent(1);
        }
        this.builder.append(operator.getRepresentation());
        if (type != Operator.Type.POSTFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
    }

    @Override
    void enter(MapExpression map) {
        ++this.indentationLevel;
        this.builder.append(" ");
        super.enter(map);
    }

    @Override
    void leave(MapExpression map) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.leave(map);
    }

    @Override
    void enter(MergeAction onCreateOrMatchEvent) {
        this.trimNewline();
        this.indent(1);
        super.enter(onCreateOrMatchEvent);
    }

    @Override
    void enter(Merge merge) {
        if (this.readingOrUpdatingClausesCount > 0) {
            this.trimNewline();
        }
        super.enter(merge);
    }

    @Override
    void leave(Merge merge) {
        ++this.readingOrUpdatingClausesCount;
        super.leave(merge);
    }

    private void trimNewline() {
        for (int i = this.builder.length() - 1; i >= 0 && this.builder.charAt(i) == ' '; --i) {
            this.builder.deleteCharAt(i);
        }
        this.builder.append("\n");
    }

    @Override
    protected Optional<String> escapeName(CharSequence unescapedName) {
        if (unescapedName == null) {
            return Optional.empty();
        }
        return Optional.of(super.escapeIfNecessary(unescapedName.toString()));
    }
}

