/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.INTERNAL, since="1.0")
public abstract class ReflectiveVisitor
implements Visitor {
    private static final Map<TargetAndPhase, Optional<Method>> VISITING_METHODS_CACHE = new ConcurrentHashMap<TargetAndPhase, Optional<Method>>();
    protected Deque<Visitable> currentVisitedElements = new LinkedList<Visitable>();
    protected final Set<AliasedExpression> visitableToAliased = new HashSet<AliasedExpression>();

    protected abstract boolean preEnter(Visitable var1);

    protected abstract void postLeave(Visitable var1);

    @Override
    public final void enter(Visitable visitable) {
        if (this.preEnter(visitable)) {
            this.currentVisitedElements.push(visitable);
            this.executeConcreteMethodIn(new TargetAndPhase(this, visitable.getClass(), Phase.ENTER), visitable);
        }
    }

    @Override
    public final void leave(Visitable visitable) {
        if (this.currentVisitedElements.peek() == visitable) {
            this.executeConcreteMethodIn(new TargetAndPhase(this, visitable.getClass(), Phase.LEAVE), visitable);
            this.postLeave(visitable);
            this.currentVisitedElements.pop();
        }
        if (visitable instanceof AliasedExpression) {
            AliasedExpression aliasedExpression = (AliasedExpression)visitable;
            this.visitableToAliased.add(aliasedExpression);
        }
    }

    private void executeConcreteMethodIn(TargetAndPhase targetAndPhase, Visitable onVisitable) {
        Optional optionalMethod = VISITING_METHODS_CACHE.computeIfAbsent(targetAndPhase, ReflectiveVisitor::findHandleFor);
        optionalMethod.ifPresent(handle -> {
            try {
                handle.invoke((Object)this, onVisitable);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    private static Optional<Method> findHandleFor(TargetAndPhase targetAndPhase) {
        for (Class clazz : targetAndPhase.classHierarchyOfVisitable) {
            for (Class c = targetAndPhase.visitorClass; c != null; c = c.getSuperclass()) {
                try {
                    Method method = c.getDeclaredMethod(((TargetAndPhase)targetAndPhase).phase.methodName, clazz);
                    method.setAccessible(true);
                    return Optional.of(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return Optional.empty();
    }

    private static class TargetAndPhase {
        private final Class<? extends ReflectiveVisitor> visitorClass;
        private final List<Class<?>> classHierarchyOfVisitable;
        private final Phase phase;

        <T extends ReflectiveVisitor> TargetAndPhase(T visitor, Class<? extends Visitable> concreteVisitableClass, Phase phase) {
            this.visitorClass = visitor.getClass();
            this.phase = phase;
            this.classHierarchyOfVisitable = new ArrayList();
            Class<? extends Visitable> classOfVisitable = concreteVisitableClass;
            do {
                this.classHierarchyOfVisitable.add(classOfVisitable);
            } while ((classOfVisitable = classOfVisitable.getSuperclass()) != null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetAndPhase)) {
                return false;
            }
            TargetAndPhase that = (TargetAndPhase)o;
            return this.visitorClass.equals(that.visitorClass) && this.classHierarchyOfVisitable.equals(that.classHierarchyOfVisitable) && this.phase == that.phase;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.visitorClass, this.classHierarchyOfVisitable, this.phase});
        }
    }

    private static enum Phase {
        ENTER("enter"),
        LEAVE("leave");

        final String methodName;

        private Phase(String methodName) {
            this.methodName = methodName;
        }
    }
}

