/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExpressionCondition;
import org.neo4j.cypherdsl.core.InternalPropertyImpl;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public interface Expression
extends Visitable {
    @NotNull
    @Contract(pure=true)
    default public AliasedExpression as(String alias) {
        Assertions.hasText(alias, "The alias may not be null or empty.");
        return new AliasedExpression(this, alias);
    }

    @NotNull
    @Contract(pure=true)
    default public AliasedExpression as(SymbolicName alias) {
        Assertions.notNull(alias, "The alias may not be null.");
        return this.as(alias.getValue());
    }

    @NotNull
    @Contract(pure=true)
    default public Condition asCondition() {
        return this instanceof Condition ? (Condition)this : new ExpressionCondition(this);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isEqualTo(Expression rhs) {
        return Conditions.isEqualTo(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition eq(Expression rhs) {
        return this.isEqualTo(rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isNotEqualTo(Expression rhs) {
        return Conditions.isNotEqualTo(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition ne(Expression rhs) {
        return this.isNotEqualTo(rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition lt(Expression rhs) {
        return Conditions.lt(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition lte(Expression rhs) {
        return Conditions.lte(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition gt(Expression rhs) {
        return Conditions.gt(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition gte(Expression rhs) {
        return Conditions.gte(this, rhs);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isTrue() {
        return Conditions.isEqualTo(this, Cypher.literalTrue());
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isFalse() {
        return Conditions.isEqualTo(this, Cypher.literalFalse());
    }

    @NotNull
    @Contract(pure=true)
    default public Condition matches(Expression expression) {
        return Conditions.matches(this, expression);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition matches(String pattern) {
        return Conditions.matches(this, Cypher.literalOf(pattern));
    }

    @NotNull
    @Contract(pure=true)
    default public Condition startsWith(Expression expression) {
        return Conditions.startsWith(this, expression);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition contains(Expression expression) {
        return Conditions.contains(this, expression);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition endsWith(Expression expression) {
        return Conditions.endsWith(this, expression);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation concat(Expression expression) {
        return Operations.concat(this, expression);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation add(Expression addend) {
        return Operations.add(this, addend);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation subtract(Expression subtrahend) {
        return Operations.subtract(this, subtrahend);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation multiply(Expression multiplicand) {
        return Operations.multiply(this, multiplicand);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation divide(Expression dividend) {
        return Operations.divide(this, dividend);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation remainder(Expression dividend) {
        return Operations.remainder(this, dividend);
    }

    @NotNull
    @Contract(pure=true)
    default public Operation pow(Expression n) {
        return Operations.pow(this, n);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isNull() {
        return Conditions.isNull(this);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isNotNull() {
        return Conditions.isNotNull(this);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition in(Expression haystack) {
        return Comparison.create(this, Operator.IN, haystack);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition isEmpty() {
        return Conditions.isEmpty(this);
    }

    @NotNull
    @Contract(pure=true)
    default public SortItem descending() {
        return SortItem.create(this, SortItem.Direction.DESC);
    }

    @NotNull
    @Contract(pure=true)
    default public SortItem ascending() {
        return SortItem.create(this, SortItem.Direction.ASC);
    }

    @NotNull
    @Contract(pure=true)
    default public Property property(String ... names) {
        return InternalPropertyImpl.create(this, names);
    }
}

