/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Expression;

@API(status=API.Status.STABLE, since="1.0")
public interface Literal<T>
extends Expression {
    @NotNull
    @Contract(pure=true)
    public String asString();

    @API(status=API.Status.STABLE, since="2021.1.0")
    public static final class UnsupportedLiteralException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 864563506445498829L;
        private final Class<?> unsupportedType;

        public UnsupportedLiteralException(String message, Object unsupportedObject) {
            super(message);
            this.unsupportedType = unsupportedObject.getClass();
        }

        public UnsupportedLiteralException(Object unsupportedObject) {
            super("Unsupported literal type: " + unsupportedObject.getClass());
            this.unsupportedType = unsupportedObject.getClass();
        }

        public Class<?> getUnsupportedType() {
            return this.unsupportedType;
        }
    }
}

