/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Dialect;

@API(status=API.Status.STABLE, since="2021.0.1")
public final class Configuration {
    private static final Configuration DEFAULT_CONFIG = Configuration.newConfig().build();
    private static final Configuration PRETTY_PRINTING = Configuration.newConfig().withPrettyPrint(true).alwaysEscapeNames(false).build();
    private final boolean prettyPrint;
    private final IndentStyle indentStyle;
    private final int indentSize;
    private final boolean alwaysEscapeNames;
    private final Set<GeneratedNames> generatedNames;
    private final Dialect dialect;

    public static Configuration defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static Configuration prettyPrinting() {
        return PRETTY_PRINTING;
    }

    public static Builder newConfig() {
        return Builder.newConfig();
    }

    private Configuration(Builder builder) {
        this.prettyPrint = builder.prettyPrint;
        this.alwaysEscapeNames = builder.alwaysEscapeNames;
        this.indentStyle = builder.indentStyle;
        this.indentSize = builder.indentSize;
        this.dialect = builder.dialect == null ? Dialect.DEFAULT : builder.dialect;
        this.generatedNames = builder.generatedNames;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public IndentStyle getIndentStyle() {
        return this.indentStyle;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public boolean isAlwaysEscapeNames() {
        return this.alwaysEscapeNames;
    }

    public Set<GeneratedNames> getGeneratedNames() {
        return this.generatedNames;
    }

    public boolean isUseGeneratedNames() {
        return !this.generatedNames.isEmpty();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.prettyPrint == that.prettyPrint && this.indentSize == that.indentSize && this.indentStyle == that.indentStyle && this.alwaysEscapeNames == that.alwaysEscapeNames && this.dialect == that.dialect && this.generatedNames.equals(that.generatedNames);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prettyPrint, this.indentStyle, this.indentSize, this.alwaysEscapeNames, this.dialect, this.generatedNames});
    }

    public String toString() {
        return "Configuration{prettyPrint=" + this.prettyPrint + ", indentStyle=" + this.indentStyle + ", indentSize=" + this.indentSize + "}";
    }

    public static final class Builder {
        private boolean prettyPrint = false;
        private IndentStyle indentStyle = IndentStyle.SPACE;
        private int indentSize = 2;
        private boolean alwaysEscapeNames = true;
        private Dialect dialect = Dialect.DEFAULT;
        private Set<GeneratedNames> generatedNames = EnumSet.noneOf(GeneratedNames.class);

        private Builder() {
        }

        static Builder newConfig() {
            return new Builder();
        }

        public Builder withPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            if (this.prettyPrint) {
                return this.alwaysEscapeNames(false);
            }
            return this;
        }

        public Builder withIndentStyle(IndentStyle indentStyle) {
            if (indentStyle == null) {
                throw new IllegalArgumentException("Indent style is required.");
            }
            this.indentStyle = indentStyle;
            return this;
        }

        public Builder withIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        public Builder alwaysEscapeNames(boolean alwaysEscapeNames) {
            this.alwaysEscapeNames = alwaysEscapeNames;
            return this;
        }

        public Builder withGeneratedNames(boolean useGeneratedNames) {
            this.generatedNames = useGeneratedNames ? EnumSet.allOf(GeneratedNames.class) : EnumSet.noneOf(GeneratedNames.class);
            return this;
        }

        public Builder withGeneratedNames(Set<GeneratedNames> useGeneratedNames) {
            this.generatedNames = Objects.requireNonNullElseGet(useGeneratedNames, () -> EnumSet.noneOf(GeneratedNames.class));
            return this;
        }

        public Builder withDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    public static enum IndentStyle {
        TAB,
        SPACE;

    }

    public static enum GeneratedNames {
        ENTITY_NAMES,
        PARAMETER_NAMES,
        ALL_ALIASES,
        INTERNAL_ALIASES_ONLY;

    }
}

