/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.net.URI;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.ExposesLoadCSV;
import org.neo4j.cypherdsl.core.LoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.UsingPeriodicCommit;

@API(status=API.Status.INTERNAL, since="2021.2.1")
final class DefaultLoadCSVStatementBuilder
extends DefaultStatementBuilder
implements LoadCSVStatementBuilder {
    private final UsingPeriodicCommit usingPeriodicCommit;
    private final LoadCSV loadCSV;

    static DefaultLoadCSVStatementBuilder create(PrepareLoadCSVStatementImpl config, String alias, @Nullable DefaultStatementBuilder source) {
        LoadCSV loadCSV = new LoadCSV(config.uri, config.withHeaders, alias);
        return source == null ? new DefaultLoadCSVStatementBuilder(config.usingPeriodicCommit, loadCSV) : new DefaultLoadCSVStatementBuilder(source, config.usingPeriodicCommit, loadCSV);
    }

    private DefaultLoadCSVStatementBuilder(UsingPeriodicCommit usingPeriodicCommit, LoadCSV loadCSV) {
        super(usingPeriodicCommit, loadCSV);
        this.usingPeriodicCommit = usingPeriodicCommit;
        this.loadCSV = loadCSV;
    }

    private DefaultLoadCSVStatementBuilder(DefaultStatementBuilder source, UsingPeriodicCommit usingPeriodicCommit, LoadCSV loadCSV) {
        super(source, usingPeriodicCommit, loadCSV);
        this.usingPeriodicCommit = usingPeriodicCommit;
        this.loadCSV = loadCSV;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public StatementBuilder withFieldTerminator(String fieldTerminator) {
        return new DefaultStatementBuilder(this.usingPeriodicCommit, this.loadCSV.withFieldTerminator(fieldTerminator));
    }

    static final class PrepareLoadCSVStatementImpl
    implements ExposesLoadCSV,
    LoadCSVStatementBuilder.OngoingLoadCSV {
        private final UsingPeriodicCommit usingPeriodicCommit;
        private final DefaultStatementBuilder source;
        private URI uri;
        private boolean withHeaders;

        PrepareLoadCSVStatementImpl(Integer rate) {
            this.usingPeriodicCommit = new UsingPeriodicCommit(rate);
            this.source = null;
        }

        PrepareLoadCSVStatementImpl(URI uri, boolean withHeaders) {
            this(uri, withHeaders, null);
        }

        PrepareLoadCSVStatementImpl(URI uri, boolean withHeaders, @Nullable DefaultStatementBuilder source) {
            this.usingPeriodicCommit = null;
            this.uri = uri;
            this.withHeaders = withHeaders;
            this.source = source;
        }

        @Override
        @NotNull
        public LoadCSVStatementBuilder as(String alias) {
            return DefaultLoadCSVStatementBuilder.create(this, alias, this.source);
        }

        @Override
        @NotNull
        public LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI newUri, boolean newWithHeaders) {
            this.uri = newUri;
            this.withHeaders = newWithHeaders;
            return this;
        }
    }
}

