/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.NameResolvingStrategy;
import org.neo4j.cypherdsl.core.renderer.Configuration;

final class GeneratedNamesStrategy
implements NameResolvingStrategy {
    private final AtomicInteger parameterCount = new AtomicInteger(0);
    private final Deque<AtomicInteger> scopedVariableCount = new ArrayDeque<AtomicInteger>();
    private final Deque<Map<Key, String>> scopedNameLookup = new ArrayDeque<Map<Key, String>>();
    private final Deque<Set<String>> scopedNamesUsed = new ArrayDeque<Set<String>>();
    private final StatementContext statementContext;
    private final Set<Configuration.GeneratedNames> config;

    GeneratedNamesStrategy(StatementContext statementContext, Set<Configuration.GeneratedNames> config) {
        this.statementContext = statementContext;
        this.config = config;
        this.enterScope(null, List.of());
    }

    Map<Key, String> nameLookup() {
        return Objects.requireNonNull(this.scopedNameLookup.peek());
    }

    @Override
    public void enterScope(Visitable cause, Collection<IdentifiableElement> imports) {
        HashMap<Key, String> newNameLookup = new HashMap<Key, String>();
        HashSet<String> newUsedNames = new HashSet<String>();
        Map<Key, String> outerNameLookup = this.scopedNameLookup.peek();
        if (outerNameLookup != null) {
            for (IdentifiableElement anImport : imports) {
                Key theKey = Key.of(anImport);
                if (!outerNameLookup.containsKey(theKey)) continue;
                newNameLookup.put(theKey, outerNameLookup.get(theKey));
            }
            newUsedNames.addAll(outerNameLookup.values());
        }
        this.scopedVariableCount.push(new AtomicInteger(0));
        this.scopedNameLookup.push(newNameLookup);
        this.scopedNamesUsed.push(newUsedNames);
    }

    @Override
    public void leaveScope(Visitable cause, Collection<IdentifiableElement> exports) {
        this.scopedVariableCount.pop();
        Map<Key, String> innerNameLookup = this.scopedNameLookup.pop();
        this.scopedNamesUsed.pop();
        Map<Key, String> outerNameLookup = Objects.requireNonNull(this.scopedNameLookup.peek());
        Set<String> previouslyUsedNames = Objects.requireNonNull(this.scopedNamesUsed.peek());
        for (IdentifiableElement anExport : exports) {
            Key theKey = Key.of(anExport);
            if (innerNameLookup.containsKey(theKey)) {
                outerNameLookup.put(theKey, innerNameLookup.get(theKey));
                continue;
            }
            if (anExport instanceof AliasedExpression) {
                AliasedExpression name = (AliasedExpression)anExport;
                outerNameLookup.put(theKey, name.getAlias());
                continue;
            }
            if (!(anExport instanceof SymbolicName)) continue;
            SymbolicName name = (SymbolicName)anExport;
            outerNameLookup.put(theKey, name.getValue());
        }
        previouslyUsedNames.addAll(innerNameLookup.values());
    }

    @Override
    public String resolve(SymbolicName symbolicName, boolean inEntity, boolean inPropertyLookup) {
        if (inPropertyLookup) {
            return this.statementContext.resolve(symbolicName);
        }
        Key theKey = Key.of(symbolicName);
        Map<Key, String> nameLookup = this.nameLookup();
        if (!this.config.contains((Object)Configuration.GeneratedNames.ENTITY_NAMES) || !inEntity && !this.config.contains((Object)Configuration.GeneratedNames.ALL_ALIASES) && !this.config.contains((Object)Configuration.GeneratedNames.INTERNAL_ALIASES_ONLY)) {
            if (nameLookup.containsKey(theKey)) {
                return nameLookup.get(theKey);
            }
            return this.statementContext.resolve(symbolicName);
        }
        return nameLookup.computeIfAbsent(theKey, key -> this.newName());
    }

    private String newName() {
        String name;
        Set<String> namesUsed = Objects.requireNonNull(this.scopedNamesUsed.peek());
        AtomicInteger variableCount = Objects.requireNonNull(this.scopedVariableCount.peek());
        while (namesUsed.contains(name = String.format("v%d", variableCount.getAndIncrement()))) {
        }
        return name;
    }

    @Override
    public String resolve(AliasedExpression aliasedExpression, boolean isNew, boolean inLastReturn) {
        if (!(this.config.contains((Object)Configuration.GeneratedNames.ALL_ALIASES) || this.config.contains((Object)Configuration.GeneratedNames.INTERNAL_ALIASES_ONLY) && !inLastReturn)) {
            return aliasedExpression.getAlias();
        }
        String result = this.newName();
        this.nameLookup().put(Key.of(aliasedExpression), result);
        return result;
    }

    @Override
    public String resolve(Parameter<?> parameter) {
        if (!this.config.contains((Object)Configuration.GeneratedNames.PARAMETER_NAMES)) {
            return this.statementContext.getParameterName(parameter);
        }
        return this.nameLookup().computeIfAbsent(Key.of(parameter), key -> {
            Parameter p = (Parameter)key.value();
            return !p.isAnon() ? String.format("p%d", this.parameterCount.getAndIncrement()) : this.statementContext.getParameterName(p);
        });
    }

    @Override
    public boolean isResolved(SymbolicName symbolicName) {
        return this.statementContext.isResolved(symbolicName);
    }

    record Key(Object value) {
        static Key of(Object o) {
            if (o instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)o;
                return new Key(aliasedExpression.asName());
            }
            return new Key(o);
        }
    }
}

